/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeContext
implements Context,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(ViewScopeContext.class.getName());
    private static final long serialVersionUID = -6245899073989073951L;

    public ViewScopeContext() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating ViewScope CDI context");
        }
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Trying to access ViewScope CDI context while it is not active");
            }
            throw new ContextNotActiveException();
        }
    }

    public <T> T get(Contextual<T> contextual) {
        ViewScopeManager manager;
        this.assertNotReleased();
        T result = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (manager = ViewScopeManager.getInstance(facesContext)) != null) {
            result = manager.getContextManager().getBean(facesContext, contextual);
        }
        return result;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creational) {
        ViewScopeManager manager;
        FacesContext facesContext;
        this.assertNotReleased();
        T result = this.get(contextual);
        if (result == null && (facesContext = FacesContext.getCurrentInstance()) != null && (result = (manager = ViewScopeManager.getInstance(facesContext)).getContextManager().getBean(facesContext, contextual)) == null) {
            result = manager.getContextManager().createBean(facesContext, contextual, creational);
        }
        return result;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        UIViewRoot viewRoot;
        boolean result = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (viewRoot = facesContext.getViewRoot()) != null) {
            result = true;
        }
        return result;
    }
}

