/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.util.JSON;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.util.annotations.Immutable;
import org.bson.util.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ReplicaSetStatus {
    static final Logger _rootLogger = Logger.getLogger("com.mongodb.ReplicaSetStatus");
    final ReplicaSetHolder _replicaSetHolder = new ReplicaSetHolder();
    final Updater _updater;
    private final Mongo _mongo;
    private final AtomicReference<String> _setName = new AtomicReference();
    private final AtomicReference<Logger> _logger = new AtomicReference<Logger>(_rootLogger);
    private final AtomicReference<String> _lastPrimarySignal = new AtomicReference();
    private volatile boolean _closed;
    static final int updaterIntervalMS;
    static final int updaterIntervalNoMasterMS;
    static final int slaveAcceptableLatencyMS;
    static final int inetAddrCacheMS;
    static final float latencySmoothFactor;
    private final MongoOptions _mongoOptions = _mongoOptionsDefaults.copy();
    private static final MongoOptions _mongoOptionsDefaults;
    static final DBObject _isMasterCmd;

    ReplicaSetStatus(Mongo mongo, List<ServerAddress> initial) {
        this._mongoOptions.socketFactory = mongo._options.socketFactory;
        this._mongo = mongo;
        this._updater = new Updater(initial);
    }

    void start() {
        this._updater.start();
    }

    public String getName() {
        return this._setName.get();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{replSetName: ").append(this._setName.get());
        sb.append(", nextResolveTime: ").append(new Date(this._updater.getNextResolveTime()).toString());
        sb.append(", members: ").append(this._replicaSetHolder);
        sb.append(", updaterIntervalMS: ").append(updaterIntervalMS);
        sb.append(", updaterIntervalNoMasterMS: ").append(updaterIntervalNoMasterMS);
        sb.append(", slaveAcceptableLatencyMS: ").append(slaveAcceptableLatencyMS);
        sb.append(", inetAddrCacheMS: ").append(inetAddrCacheMS);
        sb.append(", latencySmoothFactor: ").append(latencySmoothFactor);
        sb.append("}");
        return sb.toString();
    }

    void _checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("ReplicaSetStatus closed");
        }
    }

    public ServerAddress getMaster() {
        Node n = this.getMasterNode();
        if (n == null) {
            return null;
        }
        return n.getServerAddress();
    }

    Node getMasterNode() {
        this._checkClosed();
        return this._replicaSetHolder.get().getMaster();
    }

    public boolean isMaster(ServerAddress srv) {
        if (srv == null) {
            return false;
        }
        return srv.equals(this.getMaster());
    }

    ServerAddress getASecondary(DBObject tags) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String key : tags.keySet()) {
            tagList.add(new Tag(key, tags.get(key).toString()));
        }
        Node node = this._replicaSetHolder.get().getASecondary(tagList);
        if (node != null) {
            return node.getServerAddress();
        }
        return null;
    }

    ServerAddress getASecondary() {
        Node node = this._replicaSetHolder.get().getASecondary();
        if (node == null) {
            return null;
        }
        return node._addr;
    }

    boolean hasServerUp() {
        for (Node node : this._replicaSetHolder.get().getAll()) {
            if (!node.isOk()) continue;
            return true;
        }
        return false;
    }

    Node ensureMaster() {
        if (this._closed) {
            return null;
        }
        Node masterNode = this.getMasterNode();
        if (masterNode != null) {
            return masterNode;
        }
        this._replicaSetHolder.waitForNextUpdate();
        masterNode = this.getMasterNode();
        if (masterNode != null) {
            return masterNode;
        }
        return null;
    }

    List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        for (Node node : this._replicaSetHolder.get().getAll()) {
            addrs.add(node.getServerAddress());
        }
        return addrs;
    }

    void close() {
        this._closed = true;
        this._updater.interrupt();
    }

    public int getMaxBsonObjectSize() {
        return this._replicaSetHolder.get().getMaxBsonObjectSize();
    }

    static {
        _mongoOptionsDefaults = new MongoOptions();
        updaterIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "5000"));
        updaterIntervalNoMasterMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalNoMasterMS", "10"));
        slaveAcceptableLatencyMS = Integer.parseInt(System.getProperty("com.mongodb.slaveAcceptableLatencyMS", "15"));
        inetAddrCacheMS = Integer.parseInt(System.getProperty("com.mongodb.inetAddrCacheMS", "300000"));
        latencySmoothFactor = Float.parseFloat(System.getProperty("com.mongodb.latencySmoothFactor", "4"));
        ReplicaSetStatus._mongoOptionsDefaults.connectTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000"));
        ReplicaSetStatus._mongoOptionsDefaults.socketTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000"));
        _isMasterCmd = new BasicDBObject("ismaster", (Object)1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Updater
    extends Thread {
        private final List<UpdatableNode> _all;
        private volatile long _nextResolveTime;
        private final Random _random;

        Updater(List<ServerAddress> initial) {
            super("ReplicaSetStatus:Updater");
            this._random = new Random();
            this.setDaemon(true);
            this._all = new ArrayList<UpdatableNode>(initial.size());
            for (ServerAddress addr : initial) {
                this._all.add(new UpdatableNode(addr, this._all, ReplicaSetStatus.this._logger, ReplicaSetStatus.this._mongo, ReplicaSetStatus.this._mongoOptions, ReplicaSetStatus.this._setName, ReplicaSetStatus.this._lastPrimarySignal));
            }
            this._nextResolveTime = System.currentTimeMillis() + (long)inetAddrCacheMS;
        }

        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    int curUpdateIntervalMS = updaterIntervalNoMasterMS;
                    try {
                        this.updateAll();
                        this.updateInetAddresses();
                        ReplicaSet replicaSet = new ReplicaSet(this.createNodeList(), this._random, slaveAcceptableLatencyMS);
                        ReplicaSetStatus.this._replicaSetHolder.set(replicaSet);
                        if (replicaSet.hasMaster()) {
                            ReplicaSetStatus.this._mongo.getConnector().setMaster(replicaSet.getMaster());
                            curUpdateIntervalMS = updaterIntervalMS;
                        }
                    }
                    catch (Exception e) {
                        ((Logger)ReplicaSetStatus.this._logger.get()).log(Level.WARNING, "couldn't do update pass", e);
                    }
                    Thread.sleep(curUpdateIntervalMS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ReplicaSetStatus.this._replicaSetHolder.close();
            this.closeAllNodes();
        }

        public long getNextResolveTime() {
            return this._nextResolveTime;
        }

        public synchronized void updateAll() {
            HashSet<UpdatableNode> seenNodes = new HashSet<UpdatableNode>();
            for (int i = 0; i < this._all.size(); ++i) {
                this._all.get(i).update(seenNodes);
            }
            if (seenNodes.size() > 0) {
                Iterator<UpdatableNode> it = this._all.iterator();
                while (it.hasNext()) {
                    if (seenNodes.contains(it.next())) continue;
                    it.remove();
                }
            }
        }

        private List<Node> createNodeList() {
            ArrayList<Node> nodeList = new ArrayList<Node>(this._all.size());
            for (UpdatableNode cur : this._all) {
                nodeList.add(new Node(cur._addr, cur._names, cur._pingTimeMS, cur._ok, cur._isMaster, cur._isSecondary, cur._tags, cur._maxBsonObjectSize));
            }
            return nodeList;
        }

        private void updateInetAddresses() {
            long now = System.currentTimeMillis();
            if (inetAddrCacheMS > 0 && this._nextResolveTime < now) {
                this._nextResolveTime = now + (long)inetAddrCacheMS;
                for (UpdatableNode node : this._all) {
                    node.updateAddr();
                }
            }
        }

        private void closeAllNodes() {
            for (UpdatableNode node : this._all) {
                try {
                    node.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UpdatableNode {
        final ServerAddress _addr;
        private final Set<String> _names = Collections.synchronizedSet(new HashSet());
        private DBPort _port;
        final LinkedHashMap<String, String> _tags = new LinkedHashMap();
        boolean successfullyContacted = false;
        boolean _ok = false;
        float _pingTimeMS = 0.0f;
        boolean _isMaster = false;
        boolean _isSecondary = false;
        int _maxBsonObjectSize;
        double _priority = 0.0;
        private final AtomicReference<Logger> _logger;
        private final MongoOptions _mongoOptions;
        private final Mongo _mongo;
        private final AtomicReference<String> _setName;
        private final AtomicReference<String> _lastPrimarySignal;
        private final List<UpdatableNode> _all;

        UpdatableNode(ServerAddress addr, List<UpdatableNode> all, AtomicReference<Logger> logger, Mongo mongo, MongoOptions mongoOptions, AtomicReference<String> setName, AtomicReference<String> lastPrimarySignal) {
            this._addr = addr;
            this._all = all;
            this._mongoOptions = mongoOptions;
            this._port = new DBPort(addr, null, this._mongoOptions);
            this._names.add(addr.toString());
            this._logger = logger;
            this._mongo = mongo;
            this._setName = setName;
            this._lastPrimarySignal = lastPrimarySignal;
        }

        private void updateAddr() {
            try {
                if (this._addr.updateInetAddress()) {
                    this._port = new DBPort(this._addr, null, this._mongoOptions);
                    this._mongo.getConnector().updatePortPool(this._addr);
                    this._logger.get().log(Level.INFO, "Address of host " + this._addr.toString() + " changed to " + this._addr.getSocketAddress().toString());
                }
            }
            catch (UnknownHostException ex) {
                this._logger.get().log(Level.WARNING, null, ex);
            }
        }

        synchronized void update(Set<UpdatableNode> seenNodes) {
            try {
                UpdatableNode node;
                String host;
                long start = System.nanoTime();
                CommandResult res = this._port.runCommand(this._mongo.getDB("admin"), _isMasterCmd);
                long end = System.nanoTime();
                float newPingMS = (float)(end - start) / 1000000.0f;
                this._pingTimeMS = !this.successfullyContacted ? newPingMS : (this._pingTimeMS += (newPingMS - this._pingTimeMS) / latencySmoothFactor);
                _rootLogger.log(Level.FINE, "Latency to " + this._addr + " actual=" + newPingMS + " smoothed=" + this._pingTimeMS);
                this.successfullyContacted = true;
                if (res == null) {
                    throw new MongoInternalException("Invalid null value returned from isMaster");
                }
                if (!this._ok) {
                    this._logger.get().log(Level.INFO, "Server seen up: " + this._addr);
                }
                this._ok = true;
                this._isMaster = res.getBoolean("ismaster", false);
                this._isSecondary = res.getBoolean("secondary", false);
                this._lastPrimarySignal.set(res.getString("primary"));
                if (res.containsField("hosts")) {
                    for (Object x : (List)res.get("hosts")) {
                        host = x.toString();
                        node = this._addIfNotHere(host);
                        if (node == null || seenNodes == null) continue;
                        seenNodes.add(node);
                    }
                }
                if (res.containsField("passives")) {
                    for (Object x : (List)res.get("passives")) {
                        host = x.toString();
                        node = this._addIfNotHere(host);
                        if (node == null || seenNodes == null) continue;
                        seenNodes.add(node);
                    }
                }
                if (res.containsField("tags")) {
                    DBObject tags = (DBObject)res.get("tags");
                    for (String key : tags.keySet()) {
                        this._tags.put(key, tags.get(key).toString());
                    }
                }
                this._maxBsonObjectSize = res.containsField("maxBsonObjectSize") ? (Integer)res.get("maxBsonObjectSize") : 0x400000;
                if (res.containsField("setName")) {
                    String setName = res.get("setName").toString();
                    if (this._setName.get() == null) {
                        this._setName.set(setName);
                        this._logger.set(Logger.getLogger(_rootLogger.getName() + "." + setName));
                    } else if (!this._setName.get().equals(setName)) {
                        this._logger.get().log(Level.SEVERE, "mismatch set name old: " + this._setName.get() + " new: " + setName);
                    }
                }
            }
            catch (Exception e) {
                if (this._ok) {
                    this._logger.get().log(Level.WARNING, "Server seen down: " + this._addr, e);
                } else if (Math.random() < 0.1) {
                    this._logger.get().log(Level.WARNING, "Server seen down: " + this._addr, e);
                }
                this._ok = false;
            }
        }

        UpdatableNode _addIfNotHere(String host) {
            UpdatableNode n = this.findNode(host, this._all, this._logger);
            if (n == null) {
                try {
                    n = new UpdatableNode(new ServerAddress(host), this._all, this._logger, this._mongo, this._mongoOptions, this._setName, this._lastPrimarySignal);
                    this._all.add(n);
                }
                catch (UnknownHostException un) {
                    this._logger.get().log(Level.WARNING, "couldn't resolve host [" + host + "]");
                }
            }
            return n;
        }

        private UpdatableNode findNode(String host, List<UpdatableNode> members, AtomicReference<Logger> logger) {
            ServerAddress addr;
            for (UpdatableNode node : members) {
                if (!node._names.contains(host)) continue;
                return node;
            }
            try {
                addr = new ServerAddress(host);
            }
            catch (UnknownHostException un) {
                logger.get().log(Level.WARNING, "couldn't resolve host [" + host + "]");
                return null;
            }
            for (UpdatableNode node : members) {
                if (!node._addr.equals(addr)) continue;
                node._names.add(host);
                return node;
            }
            return null;
        }

        public void close() {
            this._port.close();
            this._port = null;
        }
    }

    @Immutable
    static final class Tag {
        final String key;
        final String value;

        Tag(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag = (Tag)o;
            if (this.key != null ? !this.key.equals(tag.key) : tag.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(tag.value) : tag.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static class Node {
        private final ServerAddress _addr;
        private final float _pingTime;
        private final Set<String> _names;
        private final Set<Tag> _tags;
        private final boolean _ok;
        private final boolean _isMaster;
        private final boolean _isSecondary;
        private final int _maxBsonObjectSize;

        Node(ServerAddress addr, Set<String> names, float pingTime, boolean ok, boolean isMaster, boolean isSecondary, LinkedHashMap<String, String> tags, int maxBsonObjectSize) {
            this._addr = addr;
            this._names = Collections.unmodifiableSet(new HashSet<String>(names));
            this._pingTime = pingTime;
            this._ok = ok;
            this._isMaster = isMaster;
            this._isSecondary = isSecondary;
            this._tags = Collections.unmodifiableSet(Node.getTagsFromMap(tags));
            this._maxBsonObjectSize = maxBsonObjectSize;
        }

        private static Set<Tag> getTagsFromMap(LinkedHashMap<String, String> tagMap) {
            HashSet<Tag> tagSet = new HashSet<Tag>();
            for (Map.Entry<String, String> curEntry : tagMap.entrySet()) {
                tagSet.add(new Tag(curEntry.getKey(), curEntry.getValue()));
            }
            return tagSet;
        }

        public boolean isOk() {
            return this._ok;
        }

        public boolean master() {
            return this._ok && this._isMaster;
        }

        public int getMaxBsonObjectSize() {
            return this._maxBsonObjectSize;
        }

        public boolean secondary() {
            return this._ok && this._isSecondary;
        }

        public ServerAddress getServerAddress() {
            return this._addr;
        }

        public Set<String> getNames() {
            return this._names;
        }

        public Set<Tag> getTags() {
            return this._tags;
        }

        public String toJSON() {
            StringBuilder buf = new StringBuilder();
            buf.append("{ address:'").append(this._addr).append("', ");
            buf.append("ok:").append(this._ok).append(", ");
            buf.append("ping:").append(this._pingTime).append(", ");
            buf.append("isMaster:").append(this._isMaster).append(", ");
            buf.append("isSecondary:").append(this._isSecondary).append(", ");
            buf.append("maxBsonObjectSize:").append(this._maxBsonObjectSize).append(", ");
            if (this._tags != null && this._tags.size() > 0) {
                buf.append("tags:").append(JSON.serialize(this._tags));
            }
            buf.append("}");
            return buf.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            if (this._isMaster != node._isMaster) {
                return false;
            }
            if (this._maxBsonObjectSize != node._maxBsonObjectSize) {
                return false;
            }
            if (this._isSecondary != node._isSecondary) {
                return false;
            }
            if (this._ok != node._ok) {
                return false;
            }
            if (Float.compare(node._pingTime, this._pingTime) != 0) {
                return false;
            }
            if (!this._addr.equals(node._addr)) {
                return false;
            }
            if (!((Object)this._names).equals(node._names)) {
                return false;
            }
            return ((Object)this._tags).equals(node._tags);
        }

        public int hashCode() {
            int result = this._addr.hashCode();
            result = 31 * result + (this._pingTime != 0.0f ? Float.floatToIntBits(this._pingTime) : 0);
            result = 31 * result + ((Object)this._names).hashCode();
            result = 31 * result + ((Object)this._tags).hashCode();
            result = 31 * result + (this._ok ? 1 : 0);
            result = 31 * result + (this._isMaster ? 1 : 0);
            result = 31 * result + (this._isSecondary ? 1 : 0);
            result = 31 * result + this._maxBsonObjectSize;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    static class ReplicaSet {
        final List<Node> all;
        final Random random;
        final List<Node> goodSecondaries;
        final Map<Tag, List<Node>> goodSecondariesByTagMap;
        final Node master;

        public ReplicaSet(List<Node> nodeList, Random random, int acceptableLatencyMS) {
            this.random = random;
            this.all = Collections.unmodifiableList(new ArrayList<Node>(nodeList));
            this.goodSecondaries = Collections.unmodifiableList(ReplicaSet.calculateGoodSecondaries(this.all, ReplicaSet.calculateBestPingTime(this.all), acceptableLatencyMS));
            HashSet<Tag> uniqueTags = new HashSet<Tag>();
            for (Node curNode : this.all) {
                for (Tag curTag : curNode._tags) {
                    uniqueTags.add(curTag);
                }
            }
            HashMap<Tag, List<Node>> goodSecondariesByTagMap = new HashMap<Tag, List<Node>>();
            for (Tag curTag : uniqueTags) {
                List<Node> taggedMembers = ReplicaSet.getMembersByTag(this.all, curTag);
                goodSecondariesByTagMap.put(curTag, Collections.unmodifiableList(ReplicaSet.calculateGoodSecondaries(taggedMembers, ReplicaSet.calculateBestPingTime(taggedMembers), acceptableLatencyMS)));
            }
            this.goodSecondariesByTagMap = Collections.unmodifiableMap(goodSecondariesByTagMap);
            this.master = this.findMaster();
        }

        public List<Node> getAll() {
            return this.all;
        }

        public boolean hasMaster() {
            return this.getMaster() != null;
        }

        public Node getMaster() {
            return this.master;
        }

        public int getMaxBsonObjectSize() {
            if (this.hasMaster()) {
                return this.getMaster().getMaxBsonObjectSize();
            }
            return 0x400000;
        }

        public Node getASecondary() {
            if (this.goodSecondaries.isEmpty()) {
                return null;
            }
            return this.goodSecondaries.get(this.random.nextInt(this.goodSecondaries.size()));
        }

        public Node getASecondary(List<Tag> tags) {
            for (Tag tag : tags) {
                Node node;
                List<Node> goodSecondariesByTag = this.goodSecondariesByTagMap.get(tag);
                if (goodSecondariesByTag == null || (node = goodSecondariesByTag.get(this.random.nextInt(goodSecondariesByTag.size()))) == null) continue;
                return node;
            }
            return null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (Node node : this.getAll()) {
                sb.append(node.toJSON()).append(",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(" ]");
            return sb.toString();
        }

        public Node findMaster() {
            for (Node node : this.all) {
                if (!node.master()) continue;
                return node;
            }
            return null;
        }

        static float calculateBestPingTime(List<Node> members) {
            float bestPingTime = Float.MAX_VALUE;
            for (Node cur : members) {
                if (!cur.secondary() || !(cur._pingTime < bestPingTime)) continue;
                bestPingTime = cur._pingTime;
            }
            return bestPingTime;
        }

        static List<Node> calculateGoodSecondaries(List<Node> members, float bestPingTime, int acceptableLatencyMS) {
            ArrayList<Node> goodSecondaries = new ArrayList<Node>(members.size());
            for (Node cur : members) {
                if (!cur.secondary() || !(cur._pingTime - (float)acceptableLatencyMS <= bestPingTime)) continue;
                goodSecondaries.add(cur);
            }
            return goodSecondaries;
        }

        static List<Node> getMembersByTag(List<Node> members, Tag tag) {
            ArrayList<Node> membersByTag = new ArrayList<Node>();
            for (Node cur : members) {
                if (!cur._tags.contains(tag)) continue;
                membersByTag.add(cur);
            }
            return membersByTag;
        }
    }

    @ThreadSafe
    static class ReplicaSetHolder {
        private volatile ReplicaSet members;

        ReplicaSetHolder() {
        }

        synchronized ReplicaSet get() {
            while (this.members == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new MongoException("Interrupted while waiting for next update to replica set status", e);
                }
            }
            return this.members;
        }

        synchronized void set(ReplicaSet members) {
            if (members == null) {
                throw new IllegalArgumentException("members can not be null");
            }
            this.members = members;
            this.notifyAll();
        }

        synchronized void waitForNextUpdate() {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new MongoException("Interrupted while waiting for next update to replica set status", e);
            }
        }

        public synchronized void close() {
            this.members = null;
            this.notifyAll();
        }

        public String toString() {
            ReplicaSet cur = this.members;
            if (cur != null) {
                return cur.toString();
            }
            return "none";
        }
    }
}

