/* ***********************************************************
Przykad 13.1 (DHTMLAPI.js)

Przykad zaczerpnity z polskiej edycji ksiki 
"JavaScript and DHTML. Receptury"
Wydawnictwo Helion, Gliwice
Copyright 2003 Danny Goodman
************************************************************ */

// DHTMLAPI.js bibliotek niezalenych od platformy funkcji
// pozycjonowania obiektw.
// Autor: Danny Goodman
// Obsuga: NN4, IE oraz DOM W3C

// zmienne globalne
var jestCSS, jestW3C, jestIE4, jestNN4, jestIE6CSS;

// zainicjowanie biblioteki po zaadowaniu strony umoliwia przegldarkom 
// utworzenie obiektw pojawiajcych si w treci dokumentu
function inicjujDHTMLAPI() {
    if (document.images) {
        jestCSS = (document.body && document.body.style) ? true : false;
        jestW3C = (jestCSS && document.getElementById) ? true : false;
        jestIE4 = (jestCSS && document.all) ? true : false;
        jestNN4 = (document.layers) ? true : false;
        jestIE6CSS = (document.compatMode && document.compatMode.indexOf("CSS1") >= 0) ? true : false;
    }
}
// definicja procedury obsugi zdarzenia, majca na celu zainicjowanie API
window.onload = inicjujDHTMLAPI;

// wyszukanie zagniedonych warstw NN4 na podstawie nazwy
function wyszukajWarstwe(dok, nazwa) {
    var obiekt;
    for (var i = 0; i < dok.layers.length; i++) {
        if (dok.layers[i].name == nazwa) {
            obiekt = dok.layers[i];
            break;
        }
        // przejcie do warstw zagniedonych (jeli jest to konieczne)
        if (dok.layers[i].document.layers.length > 0) {
            obiekt = wyszukajWarstwe(document.layers[i].document, nazwa);
        }
    }
    return obiekt;
}

// przeksztacenie nazwy obiektu lub jego referencji
// w poprawn referencj obiektu elementu
function pobierzObiektElem(ob) {
    var obiekt;
    if (typeof ob == "string") {
        if (jestW3C) {
            obiekt = document.getElementById(ob);
        } else if (jestIE4) {
            obiekt = document.all(ob);
        } else if (jestNN4) {
            obiekt = wyszukajWarstwe(document, ob);
        }
    } else {
        // przekazanie referencji obiektu
        obiekt = ob;
    }
    return obiekt;
}

// przeksztacenie nazwy obiektu lub jego referencji
// w poprawn referencj stylu (lub warstw NN4)
function pobierzObiekt(ob) {
    var obiekt = pobierzObiektElem(ob);
    if (obiekt && jestCSS) {
        obiekt = obiekt.style;
    }
    return obiekt;
}

// umieszczenie obiektu w miejscu o podanych wsprzdnych
function przesunDo(ob, x, y) {
    var obiekt = pobierzObiekt(ob);
    if (obiekt) {
        if (jestCSS) {
            // uzupenienie wartoci liczbowych
            var jednostki = (typeof obiekt.left == "string") ? "px" : 0;
            obiekt.left = x + jednostki;
            obiekt.top = y + jednostki;
        } else if (jestNN4) {
            obiekt.moveTo(x,y)
        }
    }
}

// przesunicie obiektu o x i/lub y pikseli
function przesun(ob, deltaX, deltaY) {
    var obiekt = pobierzObiekt(ob);
    if (obiekt) {
        if (jestCSS) {
            // uzupenienie warto liczbowych
            var jednostki = (typeof obiekt.left == "string") ? "px" : 0;
            obiekt.left = pobierzWspX(ob) + deltaX + jednostki;
            obiekt.top = pobierzWspY(ob) + deltaY + jednostki;
        } else if (jestNN4) {
            obiekt.moveBy(deltaX, deltaY);
        }
    }
}

// ustawienie obiekt na osi Z
function podajIndeksZ(ob, pozycjaZ) {
    var obiekt = pobierzObiekt(ob);
    if (obiekt) {
        obiekt.zIndex = pozycjaZ;
    }
}

// ustawienie koloru ta obiektu
function ustawKolorTla(ob, kolor) {
    var obiekt = pobierzObiekt(ob);
    if (obiekt) {
        if (jestNN4) {
            obiekt.bgColor = kolor;
        } else if (jestCSS) {
            obiekt.backgroundColor = kolor;
        }
    }
}

// uwidocznienie obiektu
function pokaz(ob) {
    var obiekt = pobierzObiekt(ob);
    if (obiekt) {
        obiekt.visibility = "visible";
    }
}

// ukrycie obiektu
function ukryj(ob) {
    var obiekt = pobierzObiekt(ob);
    if (obiekt) {
        obiekt.visibility = "hidden";
    }
}

// ustalenie wsprzdnej X obiektu pozycjonowanego
function pobierzWspX(ob)  {
    var elem = pobierzObiektElem(ob);
    var wynik = 0;
    if (document.defaultView) {
        var styl = document.defaultView;
        var cssDekl = styl.getComputedStyle(elem, "");
        wynik = cssDekl.getPropertyValue("left");
    } else if (elem.currentStyle) {
        wynik = elem.currentStyle.left;
    } else if (elem.style) {
        wynik = elem.style.left;
    } else if (jestNN4) {
        wynik = elem.left;
    }
    return parseInt(wynik);
}

// ustalenie wsprzdnej Y obiektu pozycjonowanego 
function pobierzWspY(ob)  {
    var elem = pobierzObiektElem(ob);
    var wynik = 0;
    if (document.defaultView) {
        var styl = document.defaultView;
        var cssDekl = styl.getComputedStyle(elem, "");
        wynik = cssDekl.getPropertyValue("top");
    } else if (elem.currentStyle) {
        wynik = elem.currentStyle.top;
    } else if (elem.style) {
        wynik = elem.style.top;
    } else if (jestNN4) {
        wynik = elem.top;
    }
    return parseInt(wynik);
}

// ustalenie szerokoci elementu
function pobierzSzerObiektu(ob)  {
    var elem = pobierzObiektElem(ob);
    var wynik = 0;
    if (elem.offsetWidth) {
//        if (elem.scrollWidth && (elem.offsetWidth != elem.scrollWidth)) {
//            wynik = elem.scrollWidth;
//        } else {
            wynik = elem.offsetWidth;
//        }
    } else if (elem.clip && elem.clip.width) {
        wynik = elem.clip.width;
    } else if (elem.style && elem.style.pixelWidth) {
        wynik = elem.style.pixelWidth;
    }
    return parseInt(wynik);
}

// ustalenie wysokoci obiektu
function pobierzWysObiektu(ob)  {
    var elem = pobierzObiektElem(ob);
    var wynik = 0;
    if (elem.offsetHeight) {
        wynik = elem.offsetHeight;
    } else if (elem.clip && elem.clip.height) {
        wynik = elem.clip.height;
    } else if (elem.style && elem.style.pixelHeight) {
        wynik = elem.style.pixelHeight;
    }
    return parseInt(wynik);
}


// ustalenie moliwej do wykorzystania szerokoci okna przegldarki
function pobierzWewnSzerOkna() {
    if (window.innerWidth) {
        return window.innerWidth;
    } else if (jestIE6CSS) {
        // ustalenie wartoci wasnoci clientWidth elementu html
        return document.body.parentElement.clientWidth;
    } else if (document.body && document.body.clientWidth) {
        return document.body.clientWidth;
    }
    return 0;
}
// ustalenie moliwej do wykorzystania wysokoci okna przegldarki
function pobierzWewnWysOkna() {
    if (window.innerHeight) {
        return window.innerHeight;
    } else if (jestIE6CSS) {
        // ustalenie wartoci wasnoci clientHeight elementu html
        return document.body.parentElement.clientHeight;
    } else if (document.body && document.body.clientHeight) {
        return document.body.clientHeight;
    }
    return 0;
}

