// globalny stan menu
var menuGotowe = false;

// zapisanie par obrazkw w pamici podrcznej przegldarki
if (document.images) {
    var obrazkiNormalne = new Array();
    obrazkiNormalne["glowna"] = new Image(20, 80);
    obrazkiNormalne["glowna"].src = "glowna_off.jpg";
    obrazkiNormalne["katalog"] = new Image(20, 80);
    obrazkiNormalne["katalog"].src  = "katalog_off.jpg";
    obrazkiNormalne["ofirmie"] = new Image(20, 80);
    obrazkiNormalne["ofirmie"].src  = "ofirmie_off.jpg";

    var obrazkiWyroznione = new Array();
    obrazkiWyroznione["glowna"] = new Image(20, 80);
    obrazkiWyroznione["glowna"].src = "glowna_on.jpg";
    obrazkiWyroznione["katalog"] = new Image(20, 80);
    obrazkiWyroznione["katalog"].src  = "katalog_on.jpg";
    obrazkiWyroznione["ofirmie"] = new Image(20, 80);
    obrazkiWyroznione["ofirmie"].src  = "ofirmie_on.jpg";
}

function stylElementu(element, WlasnoscStyluIE, WlasnoscStyluCSS) {
    if (element.currentStyle) {
        return element.currentStyle[WlasnoscStyluIE];
    } else if (window.getComputedStyle) {
        var styl = window.getComputedStyle(elem, "");
        return styl.getPropertyValue(WlasnoscStyluCSS);
    }
    return "";
}

// zmienna przechowuje wartoc najwaniejszych waciwoci
// arkusza stylw okrelajcego wygld menu
var WartosciRegulCSS = {elementMenuWysokosc:"18px",
                        elementMenuWysokoscLinii:"1.4em",
                        menuSzerokoscRamki:"2px",
                        menuWypelnienie:"3px",
                        domyslnaCzcionkaBody:"12px"
                       };

// okrelenie zawartoci menu i informacji na temat obrazkw i hiperczy
var menu = new Array();
menu[0] = {pasekMenuIdObrazka:"menuImg_1",
           pasekMenuObrazekNormalny:obrazkiNormalne["glowna"],
           pasekMenuObrazekWyrozniony:obrazkiWyroznione["glowna"],
           opcjeMenu:[],
           identyfikatorElementu:""
          };
menu[1] = {pasekMenuIdObrazka:"menuImg_2",
           pasekMenuObrazekNormalny:obrazkiNormalne["katalog"],
           pasekMenuObrazekWyrozniony:obrazkiWyroznione["katalog"],
           opcjeMenu:[ {tekst:"Produkty Deluxe", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Produkty Standard", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Export", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Zamw katalog", adresURL:"w_przygotowaniu.html"}
                     ],
           identyfikatorElementu:""
          };
menu[2] = {pasekMenuIdObrazka:"menuImg_3", 
           pasekMenuObrazekNormalny:obrazkiNormalne["ofirmie"],
           pasekMenuObrazekWyrozniony:obrazkiWyroznione["ofirmie"],
           opcjeMenu:[ {tekst:"Doniesienia prasowe", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Kadra kierownicza", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Mapa naszych bir", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Historia Firmy", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Oferty pracy", adresURL:"w_przygotowaniu.html"},
                       {tekst:"Kontakt z nami", adresURL:"w_przygotowaniu.html"}
                     ],
           identyfikatorElementu:""
          };

// stworzenie tablicy mieszajcej dla obiektw menu, 
// zawierajcej indeksy acuchowe odpowiadajce identyfikatorom
function tworzTabliceMieszajace() {
    for (var i = 0; i < menu.length; i++) {
        menu[menu[i].identyfikatorElementu] = menu[i];
        menu[menu[i].pasekMenuIdObrazka] = menu[i];
    }
}

// okrelenie procedur obsugi zdarze dla obrazkw tworzcych menu
function przypiszZdarzeniaEtykiet() {
    var element;
    for (var i = 0; i < menu.length; i++) {
        element = document.getElementById(menu[i].pasekMenuIdObrazka);
        element.onmouseover = zamien;
        element.onmouseout = zamien;
    }
}

// funkcja generuje elementy div menu oraz ich zawarto.
// wszystkie te operacje s niewidoczne dla uytkownika i wykonywane 
// na etapie tworzenia strony
function tworzMenu() {
    var menuElementDIV, opcjaMenu, hiperlaczeOpcjiMenu, obrazekPaskaMenu, wezelTekstowy, offsetLewo, offsetGora;
    
    // okrelenie podstawowych parametrw modyfikacji cakowitej wysokoci 
    // elementw div tworzcych menu
    
    var opcjaMenyWys = 0;
    var wielkoscCzcionkiBody = parseInt(stylElementu(document.body, "fontSize", "font-size"));
    // sprawdzamy czy wielko czcionki w przegldarce zostaa zmieniona przez uytkownika
    // oraz czy nowa wielko zostaa zarejestrowana jako waciwo uytego stylu
    if (wielkoscCzcionkiBody == parseInt(WartosciRegulCSS.domyslnaCzcionkaBody)) {
        opcjaMenyWys = (parseFloat(WartosciRegulCSS.elementMenuWysokosc));
    } else {
        // dziaa dobrze w Netscapie 7
        opcjaMenyWys = parseInt(parseFloat(WartosciRegulCSS.elementMenuWysokoscLinii) * wielkoscCzcionkiBody);
    }
    var aktualizacjaWysokosci = parseInt(WartosciRegulCSS.menuWypelnienie) + 
        parseInt(WartosciRegulCSS.menuSzerokoscRamki);
    if (navigator.appName == "Microsoft Internet Explorer" && 
        navigator.userAgent.indexOf("Win") != -1 && 
        (typeof document.compatMode == "undefined" || 
        document.compatMode == "BackCompat")) {
        aktualizacjaWysokosci = aktualizacjaWysokosci;
    }
    
    // wykorzystujemy tablic menu do sterowania przebiegiem ptli
    // generujcej elementy div
    for (var i = 0; i < menu.length; i++) {
        menuElementDIV = document.createElement("div");
        menuElementDIV.id = "popupmenu" + i;
        // zachowujemy identyfikator menu jako waciwo komrki tablicy menu
        menu[i].identyfikatorElementu = "popupmenu" + i;
        menuElementDIV.className = "pojemnikMenu";
        if (menu[i].opcjeMenu.length > 0) {
            menuElementDIV.style.height = (opcjaMenyWys * menu[i].opcjeMenu.length) - 
            aktualizacjaWysokosci + "px";
        } else {
            // nie wywietlamy adnego elementu div menu, jeli menu jest puste
            menuElementDIV.style.display = "none";
        }
        // definicja procedur obsugi zdarze
        menuElementDIV.onmouseover = zachowajMenu;
        menuElementDIV.onmouseout = zadajUkrycia;

        // okrelenie kolejnoci przesaniania, na wypadek gdyby na stronie byy
        // wykorzystywane warstwy
        menuElementDIV.style.zIndex = 1000;
        
        // generacja elementw opcji menu umieszczanych wewntrz elementu div
        for (var j = 0; j < menu[i].opcjeMenu.length; j++) {
            opcjaMenu = document.createElement("div");
            opcjaMenu.id = "popupmenuItem_" + i + "_" + j;
            opcjaMenu.className = "elementMenu";
            opcjaMenu.onmouseover = przelaczPodswietlenie;
            opcjaMenu.onmouseout = przelaczPodswietlenie;
            opcjaMenu.onclick = ukryjMenu;
            opcjaMenu.style.top = opcjaMenyWys * j + "px";
            hiperlaczeOpcjiMenu = document.createElement("a");
            hiperlaczeOpcjiMenu.href = menu[i].opcjeMenu[j].adresURL;
            hiperlaczeOpcjiMenu.className = "elementMenu";
            hiperlaczeOpcjiMenu.onmouseover = przelaczPodswietlenie;
            hiperlaczeOpcjiMenu.onmouseout = przelaczPodswietlenie;
            wezelTekstowy = document.createTextNode(menu[i].opcjeMenu[j].tekst);
            hiperlaczeOpcjiMenu.appendChild(wezelTekstowy);
            opcjaMenu.appendChild(hiperlaczeOpcjiMenu);
            menuElementDIV.appendChild(opcjaMenu);
        }
        // doczenie kadego elementu div menu do elementu body
        document.body.appendChild(menuElementDIV);
    }
    tworzTabliceMieszajace();
    przypiszZdarzeniaEtykiet();
    // wstpne rozmieszczenie menu
    for (i = 0; i < menu.length; i++) {
        rozmiescMenu(menu[i].identyfikatorElementu);
    }
    menuGotowe = true;
}

// inicjalizacja zmiennej globalnej uatwiajcej ukrywanie menu
var licznikCzasu;

// funkcja wywoywana w zdarzeniach mouseover wewntrz menu, w celu 
// anulowania da ukrycia menu zgaszanych (midzy innymi) przez zdarzenia mouseout
// generowanych przez obrazki stanowice opcje menu
function zachowajMenu() {
    clearTimeout(licznikCzasu);
}

function anulujWszystko() {
    zachowajMenu();
    menuGotowe = false;
}

// funkcja wywoywana podczas obsugi zdarze mouseout, w celu 
// ukrycia wszystkich menu po 1/4 sekundy, chyba e danie zostanie anulowane
function zadajUkrycia() {
    licznikCzasu = setTimeout("ukryjMenu()", 250);
}

// brutalne ukrycie wszystkich menu i odtworzenie normalnego stanu obrazkw na 
// pasku menu
function ukryjMenu() {
    for (var i = 0; i < menu.length; i++) {
       document.getElementById(menu[i].pasekMenuIdObrazka).src = menu[i].pasekMenuObrazekNormalny.src;
       var menuElem = document.getElementById(menu[i].identyfikatorElementu)
       menuElem.style.visibility = "hidden";
    }
}

// funkcja okrela pooenie elementu div tu przed jego wywietleniem
function rozmiescMenu(identyfikatorMenu){
    // wykorzystujemy obrazek paska menu jako punkt odniesienia dla div-a
    var obrazekPaskaMenu = document.getElementById(menu[identyfikatorMenu].pasekMenuIdObrazka);
    var offsetSlad = obrazekPaskaMenu;
    var offsetLewo = 0;
    var offsetGora = 0;
    while (offsetSlad) {
        offsetLewo += offsetSlad.offsetLeft;
        offsetGora += offsetSlad.offsetTop;
        offsetSlad = offsetSlad.offsetParent;
    }
    if (navigator.userAgent.indexOf("Mac") != -1 && 
        typeof document.body.leftMargin != "undefined") {
        offsetLewo += document.body.leftMargin;
        offsetGora += document.body.topMargin;
    }
    var elementDIVMenu = document.getElementById(identyfikatorMenu);
    elementDIVMenu.style.left = offsetLewo + "px";
    elementDIVMenu.style.top = offsetGora + obrazekPaskaMenu.height + "px";
}

// wywietlenie konkretnego elementu div menu
function pokazMenu(identyfikatorMenu) {
    if (menuGotowe) {
        zachowajMenu();
        ukryjMenu();
        rozmiescMenu(identyfikatorMenu);
        var menuElem = document.getElementById(identyfikatorMenu);
        menuElem.style.visibility = "visible";
    }
}

// podmienianie obrazkw wywietlanych w menu, wywoywana podczas obsugi
// zdarze myszy, zamienia style obrazkw
function przelaczPodswietlenie(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie : ((event) ? event : null);
    if (typeof menuGotowe != "undefined") {
        if (menuGotowe && zdarzenie) {
            var element = (zdarzenie.target) ? zdarzenie.target : zdarzenie.srcElement;
            if (element.nodeType == 3) {
                element = element.parentNode;
            }
            if (zdarzenie.type == "mouseover") {
                zachowajMenu();
                element.className ="elementMenuWyrozniony";
            } else {
                element.className ="elementMenu";
                zadajUkrycia();
            }
            zdarzenie.cancelBubble = true;
        }
    }
}

function zamien(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie : ((event) ? event : null);
    if (typeof menuGotowe != "undefined") {
        if (zdarzenie && (document.getElementById && document.styleSheets) && menuGotowe) {
            var element = (zdarzenie.target) ? zdarzenie.target : zdarzenie.srcElement;
            if (element.className == "menuImg") {
                if (zdarzenie.type == "mouseover") {
                    pokazMenu(menu[element.id].identyfikatorElementu);
                    element.src = menu[element.id].pasekMenuObrazekWyrozniony.src;
                } else if (zdarzenie.type == "mouseout") {
                    zadajUkrycia();
                }
                zdarzenie.cancelBubble = true;
            }
        }
    }
}

// tworzy menu wycznie w przypadku gdy s dostpne niezbdne moliwoci
function inicjujMenu() {
    if (document.getElementById && document.styleSheets) {
        setTimeout("tworzMenu()", 5);
        window.onunload=anulujWszystko;
    }
}
