// Zmienna globalna przechowujca odwoanie do wybranego elementu
var wybranyObiekt;
// Zmienna globalna przechowujca pooenie kliknicia w stosunku 
// do elementu
var offsetX, offsetY;

// Okrela globalne odwoanie do wczanego lub przeciganego 
// elementu 
function podajWybranyElement(zdarzenie) {
    var target = (zdarzenie.target) ? zdarzenie.target : zdarzenie.srcElement;
    var divID = (target.id == "pasektytulu") ? "pseudoOkno" : "";
    if (divID) {
        if (document.layers) {
            wybranyObiekt = document.layers[divID];
        } else if (document.all) {
            wybranyObiekt = document.all(divID);
        } else if (document.getElementById) {
            wybranyObiekt = document.getElementById(divID);
        }
        podajIndeksZ(wybranyObiekt, 100);
        return;
    }
    wybranyObiekt = null;
    return;
}

// Wcza wybrany element
function wlacz(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie : event;
    podajWybranyElement(zdarzenie);
    if (wybranyObiekt) {
        if (document.body && document.body.setCapture) {
            // wczamy przechwytywanie zdarze w IE/Win
            document.body.setCapture();
        }
        if (zdarzenie.pageX) {
            offsetX = zdarzenie.pageX - ((typeof wybranyObiekt.offsetLeft != "undefined") ? 
                      wybranyObiekt.offsetLeft : wybranyObiekt.left);
            offsetY = zdarzenie.pageY - ((wybranyObiekt.offsetTop) ? 
                      wybranyObiekt.offsetTop : wybranyObiekt.top);
        } else if (typeof zdarzenie.clientX != "undefined") {
            offsetX = zdarzenie.clientX - ((wybranyObiekt.offsetLeft) ? 
                      wybranyObiekt.offsetLeft : 0);
            offsetY = zdarzenie.clientY - ((wybranyObiekt.offsetTop) ? 
                      wybranyObiekt.offsetTop : 0);
        } else if (zdarzenie.offsetX || zdarzenie/offsetY) {
            offsetX = zdarzenie.offsetX - ((zdarzenie.offsetX < -2) ? 
                      0 : document.body.scrollLeft);
            offsetX -= (document.body.parentElement && 
                     document.body.parentElement.scrollLeft) ? 
                     document.body.parentElement.scrollLeft : 0
            offsetY = zdarzenie.offsetY - ((zdarzenie.offsetY < -2) ? 
                      0 : document.body.scrollTop);
            offsetY -= (document.body.parentElement && 
                     document.body.parentElement.scrollTop) ? 
                     document.body.parentElement.scrollTop : 0
        }
        zdarzenie.cancelBubble = true;
        return false;
    }
}

// Przeciganie elementu
function przeciagnij(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie : event;
    if (wybranyObiekt) {
        if (zdarzenie.pageX) {
            przesunDo(wybranyObiekt, (zdarzenie.pageX - offsetX), (zdarzenie.pageY - offsetY));
        } else if (zdarzenie.clientX || zdarzenie.clientY) {
            przesunDo(wybranyObiekt, (zdarzenie.clientX - offsetX), (zdarzenie.clientY - offsetY));
        }
        zdarzenie.cancelBubble = true;
        return false;
    }
}

// Wycza wybrany element
function zwolnij(zdarzenie) {
    if (wybranyObiekt) {
        podajIndeksZ(wybranyObiekt, 0);
        if (document.body && document.body.releaseCapture) {
            // przerwanie przechwytywania zdarze w IE/Win
            document.body.releaseCapture();
        }
        wybranyObiekt = null;
    }
}
function blockEvents(zdarzenie) {
    zdarzenie = (zdarzenie) ? zdarzenie : event;
    zdarzenie.cancelBubble = true;
    return false;
}

// Przypisuje procedury obsugi zdarze uywane zarwno w IE 
// jak i w Navigatorze
function inucjujPrzeciaganie() {
    if (document.layers) {
        // wczamy przechwytywanie poniszych zdarze w modelu
        // obsugi zdarze NN4
        document.captureEvents(Event.MOUSEDOWN | Event.MOUSEMOVE | Event.MOUSEUP);
        return;
    } else if (document.body & document.body.addEventListener) {
      // wczamy przechwytywanie poniszych zdarze w modelu
      // obsugi zdarze W3C DOM
    	document.addEventListener("mousedown", wlacz, true);
    	document.addEventListener("mousemove", przeciagnij, true);
    	document.addEventListener("mouseup", zwolnij, true);
    	return;
    }
  	document.onmousedown = wlacz;
   	document.onmousemove = przeciagnij;
   	document.onmouseup = zwolnij;
    return;
}
