// wasnoci obiektu animacji zwizane z ruchem elementu
var anim;

// inicjowanie obiektu animacji
function inicjujAnimacje() {
    anim = {idElem:"", 
            aktX:0, 
            aktY:0, 
            celX:0, 
            celY:0, 
            krokX:0, 
            krokY:0,
            deltaX:0,
            deltaY:0,
            przesX:0,
            przesY:0,
            szybkosc:1, 
            dlDrogi:1, 
            interwal:null
           };
}

// przypisanie obiektowi animacji wartoci zdefiniowanych bezporednio lub obliczonych
function inicjujAnimLin(idElem, startX, startY, koniecX, koniecY, szybkosc) {
    inicjujAnimacje();
    anim.idElem = idElem;
    anim.aktX = startX;
    anim.aktY = startY;
    anim.celX = koniecX;
    anim.celY = koniecY;
    anim.deltaX = Math.abs(koniecX - startX);
    anim.deltaY = Math.abs(koniecY - startY);
    anim.szybkosc = (szybkosc) ? szybkosc : 1;
    // ustalenie pozycji pocztkowej
    document.getElementById(idElem).style.left = startX + "px";
    document.getElementById(idElem).style.top = startY + "px";
    // dugo drogi pomidzy punktem startowym i kocowym
    anim.dlDrogi = Math.sqrt((Math.pow((startX - koniecX), 2)) + 
    (Math.pow((startY - koniecY), 2)));
    // wielkosc kroku jednostkowego wzdu kadej z osi
    anim.krokX = parseInt(((anim.celX - anim.aktX) / anim.dlDrogi) * anim.szybkosc);
    anim.krokY = parseInt(((anim.celY - anim.aktY) / anim.dlDrogi) * anim.szybkosc);
    // rozpoczcie cyklicznego wywoywania funkcji animacji
    anim.interwal = setInterval("wykonajAnimLin()", 10);
}

// obliczenie wsprzdnych kolejnego kroku i przypisanie ich wasnociom stylu
function wykonajAnimLin() {
    if ((anim.przesX + anim.krokX) <= anim.deltaX && 
        (anim.przesY + anim.krokY) <= anim.deltaY) {
        var x = anim.aktX + anim.krokX;
        var y = anim.aktY + anim.krokY;
        document.getElementById(anim.idElem).style.left = x + "px";
        document.getElementById(anim.idElem).style.top = y + "px";
        anim.przesX += Math.abs(anim.krokX);
        anim.przesY += Math.abs(anim.krokY);
        anim.aktX = x;
        anim.aktY = y;
    } else {
        document.getElementById(anim.idElem).style.left = anim.celX + "px";
        document.getElementById(anim.idElem).style.top = anim.celY + "px";
        clearInterval(anim.interwal);
    }
}
