# przykad 10.23 z punktu 10.3.1 
# (przykad 10.23 z punktu 10.3.1)  : Zaawansowane metody uczenia maszynowego : Rozwizywanie problemw nierozdzielnych za pomoc maszyn wektorw nonych : Uywanie maszyn SVM do rozwizywania problemw 
# Tytu: Maszyna SVM z niewaciwie dobranym jdrem 

set.seed(2335246L)
s$group <- sample.int(100, size = dim(s)[[1]], replace = TRUE)
sTrain <- subset(s, group > 10)
sTest <- subset(s,group <= 10)                           		# Uwaga 1.  

library('e1071')
mSVMV <- svm(class ~ x + y, data = sTrain, kernel = 'linear', type = 'nu-classification') 		# Uwaga 2. 
sTest$predSVMV <- predict(mSVMV, newdata = sTest, type = 'response')     		# Uwaga 3. 

shading <- expand.grid( 	# Uwaga 4.  
  x = seq(-1.5, 1.5, by = 0.01),
  y = seq(-1.5, 1.5, by = 0.01))
shading$predSVMV <- predict(mSVMV, newdata = shading, type = 'response')

ggplot(mapping = aes(x = x, y = y)) +                         	# Uwaga 5.
  geom_tile(data = shading, aes(fill = predSVMV),
            show.legend = FALSE, alpha = 0.5) +
  scale_color_manual(values = c("#d95f02", "#1b9e77")) +
  scale_fill_manual(values = c("white", "#1b9e77")) +
  geom_text(data = sTest, aes(label = predSVMV), 
            size = 12) +
  geom_text(data = s, aes(label = class, color = class),
            alpha = 0.7) +
  coord_fixed() + 
  theme_bw() + 
  theme(legend.position = 'none') +
  ggtitle("Jdro liniowe")

# Uwaga 1. 
#   Przygotowanie do prby okrelenia etykiet klas w danych spiralnych ze wsprzdnych za pomoc maszyny SVM. 

# Uwaga 2. 
#   Tworzy model wektorw nonych za pomoc jdra vanilladot (niezbyt dobrego jdra).Wykorzystuje model do przewidywania klas na danych odoonych. 

# Uwaga 3. 
#   Wykorzystuje model do przewidywania klas na danych odoonych. 

# Uwaga 4. 
#   Wywouje model na siatce punktw, dziki czemu zostaje wygenerowane to prezentujce poznane pojcia. 

# Uwaga 5. 
#   Tworzy wykres przewidywa naoonych na kopie wszystkich danych, dziki czemu moemy przekona si, czy predykcje zgadzaj si z pierwotnymi etykietami. 

