# przykad 10.21 z punktu 10.2.5 
# (przykad 10.21 z punktu 10.2.5)  : Zaawansowane metody uczenia maszynowego : Wykrywanie relacji niemonotonicznych za pomoc uoglnionych modeli addytywnych : Stosowanie modelu GAM w regresji logistycznej 
# Tytu: Regresja logistyczna w modelu GAM  

form2 <- as.formula("DBWT < 2000 ~ s(PWGT) + s(WTGAIN) +
                                              s(MAGER) + s(UPREVIS)")
glogmod <- gam(form2, data = train, family = binomial(link = "logit"))

glogmod$converged
## [1] TRUE

summary(glogmod)
## Family: binomial 
## Link function: logit 
##
## Formula:
## DBWT < 2000 ~ s(PWGT) + s(WTGAIN) + s(MAGER) + s(UPREVIS)
##
## Parametric coefficients:
##             Estimate Std. Error z value Pr(>|z|)    
## (Intercept) -3.94085    0.06794     -58   <2e-16 ***
## ---
## Signif. codes:  0 *** 0.001 ** 0.01 * 0.05 . 0.1   1
##
## Approximate significance of smooth terms: 
##              edf Ref.df  Chi.sq  p-value    
## s(PWGT)    1.905  2.420   2.463  0.36412                 	# Uwaga 1. 
## s(WTGAIN)  3.674  4.543  64.426 1.72e-12 ***
## s(MAGER)   1.003  1.005   8.335  0.00394 ** 
## s(UPREVIS) 6.802  7.216 217.631  < 2e-16 ***
## ---
## Signif. codes:  0 *** 0.001 ** 0.01 * 0.05 . 0.1   1
##
## R-sq.(adj) =  0.0331   Deviance explained = 9.14%        	# Uwaga 2. 
## UBRE score = -0.76987  Scale est. = 1         n = 14386

# Uwaga 1. 
#   Zwr uwag na du warto p powizan z wag matki (PGWT). Oznacza to, e nie jest udowodniony statystycznie istotny wpyw wagi matki (PGWT) na wynik. 

# Uwaga 2. 
#   Dewiancja wyjaniona (Deviance explained) to inaczej pseudo R-kwadrat: 1-(dewiancja/dewiancja_zerowa). 

