# przykad 10.13 z punktu 10.2.2 
# (przykad 10.13 z punktu 10.2.2)  : Zaawansowane metody uczenia maszynowego : Wykrywanie relacji niemonotonicznych za pomoc uoglnionych modeli addytywnych : Przykad regresji jednowymiarowej 
# Tytu: Stosowanie modelu regresji liniowej do naszych przykadowych danych 

lin_model <- lm(y ~ x, data = train)
summary(lin_model)

## 
## Call:
## lm(formula = y ~ x, data = train)
## 
## Residuals:
##     Min      1Q  Median      3Q     Max 
## -17.698  -1.774   0.193   2.499   7.529 
## 
## Coefficients:
##             Estimate Std. Error t value Pr(>|t|)    
## (Intercept)  -0.8330     0.1161  -7.175 1.51e-12 ***
## x             0.7395     0.1197   6.180 9.74e-10 ***
## ---
## Signif. codes:  0 '***' 0.001 '**' 0.01 '*' 0.05 '.' 0.1 ' ' 1
## 
## Residual standard error: 3.485 on 899 degrees of freedom
## Multiple R-squared:  0.04075,    Adjusted R-squared:  0.03968 
## F-statistic: 38.19 on 1 and 899 DF,  p-value: 9.737e-10

rmse <- function(residuals) {                    	# Uwaga 1. 
  sqrt(mean(residuals^2))
}

train$pred_lin <- predict(lin_model, train)              	# Uwaga 2. 
resid_lin <- with(train, y - pred_lin)
rmse(resid_lin)
## [1] 3.481091

library(ggplot2)                                  	# Uwaga 3.

ggplot(train, aes(x = pred_lin, y = y)) + 
  geom_point(alpha = 0.3) + 
  geom_abline()

# Uwaga 1. 
#   Funkcja dodatkowa, suca do obliczania bdu RMSE z wektora wartoci resztowych. 

# Uwaga 2. 
#   Oblicza bd RMSE tego modelu dla danych uczcych. 

# Uwaga 3. 
#    Tworzy wykres zmiennej y w funkcji przewidywa. 

