# przykad 7.21 z punktu 7.3.1 
# (przykad 7.21 z punktu 7.3.1)  : Regresja liniowa i logistyczna : Regularyzacja : Przykad kwazi-separacji 
# Tytu: Przygotowanie danych cars

cars <- read.table(
  'UCICar/car.data.csv',
  sep = ',',
  header = TRUE,
  stringsAsFactor = TRUE
)


vars <- setdiff(colnames(cars), "rating")        	# Uwaga 1. 

cars$fail <- cars$rating == "unacc"
outcome <- "fail"                                	# Uwaga 2.

set.seed(24351)
gp <- runif(nrow(cars))                              	# Uwaga 3.

library("zeallot")
c(cars_test, cars_train) %<-% split(cars, gp < 0.7)  	# Uwaga 4. 

nrow(cars_test)
## [1] 499
nrow(cars_train)
## [1] 1229

# Uwaga 1. 
#   Pobiera zmienne wejciowe. 

# Uwaga 2. 
#   Chcesz przewidywa, czy samochd otrzyma ocen unacc. 

# Uwaga 3. 
#   Tworzy zmienn grupowania w celu podziau na zbiory testowy/uczcy (70% danych trafia do zbioru uczcego, 30% do zbioru testowego).

# Uwaga 4. 
#   Funkcja split() zwraca list dwch grup, gdzie grupa gp < 0.7 == FALSE jest pierwsza. Operator przypisania wielokrotnego %<-% z pakietu zeallot przyjmuje t list wartoci i umieszcza je w zmiennych cars_test oraz cars_train. 

