# nieoficjalny przykad 5.62 z punktu 5.5.1 
# (nieoficjalny przykad 5.62 z punktu 5.5.1)  : Inynieria i ksztatowanie danych : Transformacje przestawiajce : Przenoszenie danych z formy szerokiej do wysokiej  

library("datasets")
library("xts")

# przenosi indeks dat do kolumny
dates <- index(as.xts(time(Seatbelts)))
Seatbelts <- data.frame(Seatbelts) 
Seatbelts$date <- dates

# ogranicza zakres dat do lat 1982 i 1983
Seatbelts <- Seatbelts[(Seatbelts$date >= as.yearmon("sty 1982")) &
                         (Seatbelts$date <= as.yearmon("gru 1983")),
                       , drop = FALSE]
Seatbelts$date <- as.Date(Seatbelts$date)
# Zaznacza, jeli bya wprowadzona ustawa o pasach
Seatbelts$law <- ifelse(Seatbelts$law==1, "new law", "pre-law")
# wyznacza interesujce nas kolumny
Seatbelts <- Seatbelts[, c("date", "DriversKilled", "front", "rear", "law")]

head(Seatbelts)

##           date DriversKilled front rear     law
## 157 1982-01-01           115   595  238 pre-law
## 158 1982-02-01           104   673  285 pre-law
## 159 1982-03-01           131   660  324 pre-law
## 160 1982-04-01           108   676  346 pre-law
## 161 1982-05-01           103   755  410 pre-law
## 162 1982-06-01           115   815  411 pre-law

