# nieoficjalny przykad 5.17 z punktu 5.1.3 
# (nieoficjalny przykad 5.17 z punktu 5.1.3)  : Inynieria i ksztatowanie danych : Dobieranie danych : Wyznaczanie kolejnoci rzdw 

library("data.table")

# nowa kopia dla wyniku rozwizania
DT_zakupy <- as.data.table(zakupy)[order(dzie, godzina), 
             .(godzina = godzina,
               n_zakup = n_zakup, 
               suma_bieca = cumsum(n_zakup)),
             by = "dzie"]                      	# # Uwaga 1. 
# print(DT_zakupy)                             	# Uwaga 2.  

# rozwizanie "na miejscu"
DT_zakupy <- as.data.table(zakupy)
sortowane_kol <- c("dzie", "godzina")
setorderv(DT_zakupy, sortowane_kol)
DT_zakupy[ , suma_bieca := cumsum(n_zakup), by = "dzie"]
# print(DT_zakupy)                              	# Uwaga 3.

# Nie zmienia kolejnoci rzeczywistego zrnicowania danych!
DT_zakupy <- as.data.table(zakupy)
DT_zakupy[order(dzie, godzina), 
             `:=`(godzina = godzina,
               n_zakup = n_zakup, 
               suma_bieca = cumsum(n_zakup)),
             by = "dzie"]
# print(DT_zakupy)                               	# Uwaga 4.

# Uwaga 1. 
#   Dodanie sowa kluczowego by przeksztaca obliczenie w obliczenie grupowe. 

# Uwaga 2. 
#   Pierwsze rozwizanie: wynik jest drug kopi notacji danych .(=). W rezultacie wywietlane s jedynie kolumny uyte w obliczeniach (takie jak dzie) i te, ktre jawnie przypiszemy. 

# Uwaga 3. 
#   Drugie rozwizanie: wynik jest obliczany na miejscu poprzez posortowanie tabeli tu przed przeprowadzeniem oblicze grupowych. 

# Uwaga 4. 
#   Trzecie rozwizanie: kolejno uzyskanego wyniku jest taka sama jak w pierwotnej tabeli, natomiast suma skumulowana jest obliczana tak, jakbymy uoyli kolejno tabeli, obliczyli pogrupowan sum biec, a nastpnie przywrcili tabel do oryginalnego szyku. 

