# przykad 4.9 z punktu 4.2.2 
# (przykad 4.9 z punktu 4.2.2)  : Zarzdzanie danymi : Przeksztacenia danych : rodkowanie i skalowanie 
# Tytu: rodkowanie i skalowanie wieku  

(mean_age <- mean(training_prepared$age))                 	# Uwaga 1. 
## [1] 49.21647

(sd_age <- sd(training_prepared$age))                     	# Uwaga 2. 
## [1] 18.0124

print(mean_age + c(-sd_age, sd_age))                      	# Uwaga 3. 
## [1] 31.20407 67.22886

training_prepared$scaled_age <- (training_prepared$age - mean_age) / sd_age 	# Uwaga 4.

training_prepared %>% 
  filter(abs(age - mean_age) < sd_age) %>%
  select(age, scaled_age) %>%
  head()

##   age scaled_age                                      	# Uwaga 5. 
## 1  67  0.9872942
## 2  54  0.2655690
## 3  61  0.6541903
## 4  64  0.8207422
## 5  57  0.4321210
## 6  55  0.3210864

training_prepared %>% 
  filter(abs(age - mean_age) > sd_age) %>%
  select(age, scaled_age) %>%
  head()

##   age scaled_age                                       	# Uwaga 6.
## 1  24  -1.399951
## 2  82   1.820054
## 3  31  -1.011329
## 4  93   2.430745
## 5  76   1.486950
## 6  26  -1.288916

# Uwaga 1. 
#   Przyjmuje redni. 

# Uwaga 2. 
#   Przyjmuje odchylenie standardowe. 

# Uwaga 3. 
#   Typowy przedzia wiekowy dla tej populacji wynosi od 31 do 67 lat. 

# Uwaga 4. 
#   Wykorzystuje warto redni jako rodek ukadu wsprzdnych (punkt odniesienia) i przeskaluje odlego od redniej od j ednostk odchylenia standardowego. 

# Uwaga 5. 
#   Klienci w przedziale typowego wieku maj warto bezwzgldn zmiennej scaled_age mniejsz od 1. 

# Uwaga 6. 
#   Klienci wykraczajcy poza przedzia typowego wieku maj warto bezwzgldn zmiennej scaled_age wiksz od 1. 

