#
# Definiujemy tu logikę serwera aplikacji sieciowej Shiny. Możesz uruchomić 
# aplikację poprzez kliknięcie przycisku 'Run App' znajdującego się ponad kodem.
#
# Więcej informacji na temat tworzenia aplikacji wykorzystujących Shiny znajdziesz tutaj:
# 
#    http://shiny.rstudio.com/
#

library(shiny)
library(zeallot)

source("buzzutils.R")

#
# Inicjalizuje aplikację
#

# wczytuje listę zmiennych, a także dane modelu i zestaw danych testowych
c(varslist, fmodel, buzztest) %<-% readRDS("../thRS500.RDS")
predictions <- predict(fmodel, newdata = buzztest, type="prob")[,2, drop=TRUE]
  
#
#  Serwer
#  
shinyServer(function(input, output) {
  
 perflist <- reactive(accuracyMeasures(predictions,
                                       buzztest$buzz,
                                       threshold = input$threshold)
                       )

  output$label = renderText(paste("Próg:", input$threshold))
  output$confusionMatrix = renderTable(perflist()$confmat,
                                       digits=0,  # gdyż mamy do czynienia ze zliczeniami, a nie rzeczywistymi wartościami liczbowymi
                                       rownames=TRUE,
                                       bordered=TRUE)
  output$performanceTable = renderTable(perflist()$perfmetrics)


})



