package com.winvector.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class BurstMap {
	public final String origString;
	private final Map<String,Object> burst;
	
	public BurstMap(final String origString, final Map<String,Object> burst) {
		this.origString = origString;
		this.burst = burst;
	}
	
	public boolean isEmpty() {
		return burst.isEmpty();
	}
	
	public Set<String> keySet() {
		return burst.keySet();
	}

	public String getAsString(final String key) {
		final Object v = burst.get(key);
		if(v==null) {
			return null;
		}
		if(v instanceof String) {
			return (String)v;
		}
		return v.toString();
	}
	
	
	private static Set<String> doubleMissingVauesLC = new HashSet<String>();
	static {
		doubleMissingVauesLC.add("");
		doubleMissingVauesLC.add("#");
		doubleMissingVauesLC.add((""+Double.NaN).toLowerCase());
		doubleMissingVauesLC.add("na");
		doubleMissingVauesLC.add("null");
		doubleMissingVauesLC.add("nill");
	}
	
	public static boolean missingDoubleValue(final String s) {
		if(s==null) {
			return true;
		}
		final String t = s.trim().toLowerCase();
		if(t.length()<=0) {
			return true;
		}
		return doubleMissingVauesLC.contains(t);
	}
	
	public static String doublePosInfString = "" + Double.POSITIVE_INFINITY;
	public static String doubleNegInfString = "" + Double.NEGATIVE_INFINITY;
	
	public double getAsDouble(final String key) {
		final Object v = burst.get(key);
		if(v==null) {
			return Double.NaN;
		}
		if(v instanceof Number) {
			return ((Number)v).doubleValue();
		}
		final String vstr;
		if(v instanceof String) {
			vstr = ((String)v).trim();;
		} else {
			vstr = v.toString().trim();
		}
		if(missingDoubleValue(vstr)) {
			return Double.NaN;
		}
		if(vstr.equalsIgnoreCase(doublePosInfString)) {
			return Double.POSITIVE_INFINITY;
		}
		if(vstr.equalsIgnoreCase(doubleNegInfString)) {
			return Double.NEGATIVE_INFINITY;
		}
		try {
			return Double.parseDouble(vstr);
		} catch (Exception ex) {
			return Double.NaN;
		}
	}
	
	public Long getAsLong(final String key) {
		final Object v = burst.get(key);
		if(v==null) {
			return null;
		}
		if(v instanceof Number) {
			return ((Number)v).longValue();
		}
		final String vstr;
		if(v instanceof String) {
			vstr = (String)v;
		} else {
			vstr = v.toString();
		}
		if(missingDoubleValue(vstr)) {
			return null;
		}
		try {
			return Long.parseLong(vstr.trim());
		} catch (Exception ex) {
			return null;
		}
	}
	
	@Override
	public String toString() {
		final StringBuilder b = new StringBuilder();
		b.append("\"");
		b.append(origString);
		b.append("\"\t->");
		for(final Map.Entry<String,Object> me: burst.entrySet()) {
			final String key = me.getKey();
			final Object value = me.getValue();
			if(value!=null) {
				final String typeStr = value.getClass().getName();
				b.append("\t" + key + "=" + typeStr + ":" + value);
			} else {
				b.append("\t" + key + "=" + value);
			}
		}
		return b.toString();
	}
}
