# przykad B.22 z punktu B.3.2 
# (przykad B.22 z punktu B.3.2)  : Wane pojcia z dziedziny statystyki : Przykady spojrzenia na dane z perspektywy statystyki : Problem pominitych zmiennych 
# Tytu: Generowanie danych uzyskujcych w miar upywu czasu coraz lepsze wartoci 

set.seed(2535251)
s <- data.frame(week = 1:100)
s$Caco2A2BPapp <- sort(sample(d$Caco2A2BPapp,100,replace=T),
                       decreasing=T)
sigmoid <- function(x) {1/(1 + exp(-x))}
s$FractionHumanAbsorption <-                      	# Uwaga 1. 
  sigmoid(
    7.5 + 0.5 * log(s$Caco2A2BPapp) +              	# Uwaga 2. 
      s$week / 10 - mean(s$week / 10) +              	# Uwaga 3. 
      rnorm(100) / 3                                 	# Uwaga 4. 
  )
write.table(s, 'synth.csv', sep=',',
            quote = FALSE, row.names = FALSE)

# Uwaga 1. 
#   Tworzy przykady syntetyczne. 

# Uwaga 2. 
#   Dodaje kolumn Caco2 do relacji wchaniania wykrytej w pierwotnym zestawie danych. Zwr uwag, e relacja jest pozytywna: w naszym syntetycznym zestawie danych lepsze wartoci Caco2 zawsze wi si z lepszym wchanianiem. Przeksztacamy logarytmicznie dane Caco2, poniewa rozcigaj si na ponad trzy dekady. 

# Uwaga 3. 
#   Dodaje zaleny od czasu czon o redniej 0, symulujcy efekty usprawnie w miar postpw projektu.  

# Uwaga 4. 
#   Dodaje czon szumu o redniej 0. 

