# przykad 7.25 z punktu 7.3.1 
# (przykad 7.25 z punktu 7.3.1)  : Regresja liniowa i logistyczna : Regularyzacja : Przykad kwazi-separacji 
# Tytu: Sprawdzanie wydajnoci modelu logistycznego 

cars_test$pred_glm <- predict(model_glm, 
                              newdata=cars_test,
                              type = "response")                 	# Uwaga 1. 

library(sigr)                                                       	# Uwaga 2.  

confmat <- function(dframe, predvar) {                               	# Uwaga 3.
  cmat <- table(truth = ifelse(dframe$fail, "unacceptable", "passed"),
                prediction = ifelse(dframe[[predvar]] > 0.5, 
                                    "unacceptable", "passed"))
  accuracy <- sum(diag(cmat)) / sum(cmat)
  deviance <- calcDeviance(dframe[[predvar]], dframe$fail)
  
  list(confusion_matrix = cmat,
       accuracy = accuracy,
       deviance = deviance)
  
}

confmat(cars_test, "pred_glm")   
## $confusion_matrix
##               prediction
## truth          passed unacceptable
##   passed          150            9
##   unacceptable     17          323
## 
## $accuracy
## [1] 0.9478958
## 
## $deviance
## [1] 97.14902

# Uwaga 1. 
#   Uzyskuje prognozy modelu dla zbioru testowego. 

# Uwaga 2. 
#   Docza pakiet sigr w celu obliczenia dewiancji (pakiet ten zawiera wiele podsumowa i testw trafnoci dopasowania). 

# Uwaga 3. 
#   Dodatkowa funkcja, suca do obliczania macierzy pomyek, dokadnoci i dewiancji. 

