# nieoficjalny przyklad A.5 z punktu A.3.1 
# (nieoficjalny przyklad A.5 z punktu A.3.1)  : Korzystanie z R i innych narzdzi : Stosowanie baz danych wraz z R : Realizowanie kwerend bazodanowych za pomoc generatora kwerend

library("rquery")

raw_connection <- DBI::dbConnect(RPostgres::Postgres(),
                                 host = 'localhost',
                                 port = 5432,
                                 user = 'johnmount',
                                 password = '')            	# Uwaga 1. 

dbopts <- rq_connection_tests(raw_connection)                  	# Uwaga 2. 
db <- rquery_db_info(
  connection = raw_connection,
  is_dbi = TRUE,
  connection_options = dbopts)

data_handle <- rq_copy_to(                                      	# Uwaga 3. 
  db, 
  'oferty',
  wrapr::build_frame(
    "nazwa_uzytkownika"  , "produkt"                            , "rabat"   , "przewidywane_powinowactwo_ofert" |
      "John"             , "Gra planszowa Pandemia"             , 0.1       , 0.8596                            |
      "Nina"             , "Gra planszowa Pandemia"             , 0.2       , 0.1336                            |
      "John"             , "Laptop Dell XPS"                    , 0.1       , 0.2402                            |
      "Nina"             , "Laptop Dell XPS"                    , 0.05      , 0.3179                            |
      "John"             , "Opowiesci z roznych kieszeni apeka", 0.05      , 0.2439                            |
      "Nina"             , "Opowiesci z roznych kieszeni apeka", 0.05      , 0.06909                           |
      "John"             , "Pioro wieczne Pelikan M200"         , 0.2       , 0.6706                            |
      "Nina"             , "Pioro wieczne Pelikan M200"         , 0.1       , 0.616                             ),
  temporary = TRUE, 
  overwrite = TRUE)

# Uwaga 1. 
#   Za pomoc pakietu DBI czy si z baz danych. W tym przypadku tworzy now baz danych SQLite, umieszczon w pamici. 

# Uwaga 2. 
#   Tworzy funkcj otaczajc rquery, umoliwiajc poczenie. 

# Uwaga 3. 
#   Kopiuje przykadowe dane do bazy danych. 

