# przykad 7.17 z punktu 7.2.5 
# (przykad 7.17 z punktu 7.2.5)  : Regresja liniowa i logistyczna : Stosowanie regresji logistycznej : Odczytywanie podsumowania modelu i charakteryzowanie wspczynnikw 
# Tytu: Obliczanie dewiancji 

loglikelihood <- function(y, py) {                                 	# Uwaga 1.  
  sum(y * log(py) + (1-y)*log(1 - py))
}

(pnull <- mean(as.numeric(train$atRisk))  )                              	# Uwaga 2.
## [1] 0.01920912

(null.dev <- -2  *loglikelihood(as.numeric(train$atRisk), pnull) )        	# Uwaga 3. 
## [1] 2698.716

model$null.deviance                                                     	# Uwaga 4. 
## [1] 2698.716

pred <- predict(model, newdata = train, type = "response")      	# Uwaga 5. 
(resid.dev <- -2 * loglikelihood(as.numeric(train$atRisk), pred) )         	# Uwaga 6. 
## [1] 2462.992

model$deviance                                                         	# Uwaga 7.
## [1] 2462.992

testy <- as.numeric(test$atRisk)                                    	# Uwaga 8. 
testpred <- predict(model, newdata = test,
                    type = "response")
( pnull.test <- mean(testy) )
## [1] 0.0172713

( null.dev.test <- -2 * loglikelihood(testy, pnull.test) )
## [1] 2110.91

( resid.dev.test <- -2 * loglikelihood(testy, testpred) )
## [1] 1947.094

# Uwaga 1. 
#   Funkcja obliczajca logarytm wiarygodnoci zestawu danych. Zmienna y stanowi wynik w postaci numerycznej (1 dla przykadw pozytywnych, 0 dla negatywnych). Zmienna py jest przewidywanym prawdopodobiestwem, e y==1. 

# Uwaga 2. 
#   Oblicza odsetek przykadw pozytywnych w zestawie danych. 

# Uwaga 3. 
#   Oblicza dewiancj zerow. 

# Uwaga 4.
#   W przypadku danych uczcych dewiancja zerowa jest przechowywana w gniedzie model$null.deviance. 

# Uwaga 5.
#   Przewiduje prawdopodobiestwo dla danych uczcych. 

# Uwaga 6.
#   Oblicza dewiancj modelu dla danych uczcych. 

# Uwaga 7. 
#   W przypadku danych uczcych dewiancja modelu jest przechowywana w gniedzie model$deviance. 

# Uwaga 8. 
#   Oblicza dewiancj zerow i dewiancj resztow dla zbioru testowego. 

