# przykad 6.1 z punktu 6.2.3 
# (przykad 6.1 z punktu 6.2.3)  : Wybr i ocena modeli : Ocenianie modeli : Ocenianie modeli klasyfikacyjnych 
# Tytu: Tworzenie i stosowanie modelu regresji logistycznej klasyfikujcego spam 

spamD <- read.table('Spambase/spamD.tsv',header=T,sep='\t')              	# Uwaga 1. 

spamTrain <- subset(spamD,spamD$rgroup  >= 10)                	# Uwaga 2. 
spamTest <- subset(spamD,spamD$rgroup < 10)

spamVars <- setdiff(colnames(spamD), list('rgroup','spam'))     	# Uwaga 3. 
spamFormula <- as.formula(paste('spam == "spam"',
                                paste(spamVars, collapse = ' + '),sep = ' ~ '))

spamModel <- glm(spamFormula,family = binomial(link = 'logit'),     	# Uwaga 4. 
                 data = spamTrain)

spamTrain$pred <- predict(spamModel,newdata = spamTrain,        	# Uwaga 5. 
                          type = 'response')
spamTest$pred <- predict(spamModel,newdata = spamTest,
                         type = 'response')

# Uwaga 1. 
#   Wczytuje dane. 

# Uwaga 2. 
#   Dzieli dane na zbir uczcy i testowy. 

# Uwaga 3. 
#   Tworzy wzr opisujcy model.

# Uwaga 4. 
#   Dopasowuje model regresji logistycznej.  

# Uwaga 5. 
#   Uzyskuje predykcje dla zbiorw uczcego i testowego.

