# nieoficjalny przykad 2.9 z punktu 2.1.2 
# (nieoficjalny przykad 2.9 z punktu 2.1.2)  : Wprowadzenie do jzyka R i danych : Pocztki z R : Programowanie w R

dane <- data.frame(przychody = c(2, 1, 2),    	# Uwaga 1. 
                   klucz_sortowania = c("b", "c", "a"), 
                   stringsAsFactors = FALSE)
print(dane)

#   przychody klucz_sortowania
# 1         2                b
# 2         1                c
# 3         2                a

. <- dane                                     	# Uwaga 2. 
. <- .[order(.$klucz_sortowania), , drop = FALSE]     	# Uwaga 3. 
.$uporzadkowana_suma_przychodow <- cumsum(.$przychody)
.$ulamek_widzianych_przychodow <- .$uporzadkowana_suma_przychodow/sum(.$przychody)
wynik <- .                                   	# Uwaga 4. 

print(wynik)

#   przychody klucz_sortowania uporzadkowana_suma_przychodow ulamek_widzianych_przychodow
# 3         2                a                             2                          0.4
# 1         2                b                             4                          0.8
# 2         1                c                             5                          1.0

# Uwaga 1. 
#   Nasze dane referencyjne (przykadowe).. 

# Uwaga 2. 
#   Przypisuje nasze dane do zmiennej tymczasowej .. Pierwotne wartoci pozostan w zmiennej data, dziki czemu w razie potrzeby atwo bdzie powrci do pocztku oblicze. 

# Uwaga 3. 
#   Polecenie order suy do szeregowania rzdw. Argument drop = FALSE nie jest konieczny, ale dobrze wyrobi sobie nawyk jego wstawiania. W przypadku jednokolumnowych obiektw data.frame bez zdefiniowanego argumentu drop = FALSE operator indeksowania [,] przeksztaci wynik w wektor, co niemal zawsze stanowi problem dla programisty. Argument drop = FALSE uniemoliwia to przeksztacenie, dlatego warto go wstawia tak na wszelki wypadek, a do tego okazuje si niezbdny wtedy, gdy obiekt data.frame zawiera tylko jedn kolumn lub gdy nie wiemy, czy obiekt ten zawiera wicej kolumn (moe on pochodzi z nieznanego rda). 

# Uwaga 4. 
#   Przypisuje wynik ze zmiennej . do zmiennej o nazwie atwiejszej do zapamitania. 

