# przykad 4.7 z podrozdziau 4.2 
# (przykad 4.7 z podrozdziau 4.2)  : Zarzdzanie danymi : Przeksztacenia danych
# Tytu: Normalizowanie dochodw na podstawie miejsca zamieszkania 

library(dplyr)
median_income_table <- readRDS("Custdata/median_income.RDS")                      	# Uwaga 1. 
head(median_income_table)  

##   state_of_res median_income
## 1      Alabama         21100
## 2       Alaska         32050
## 3      Arizona         26000
## 4     Arkansas         22900
## 5   California         25000
## 6     Colorado         32000

training_prepared <-  training_prepared %>%
  left_join(., median_income_table, by="state_of_res") %>%             	# Uwaga 2. 
  mutate(income_normalized = income/median_income) 

head(training_prepared[, c("income", "median_income", "income_normalized")]) 	# Uwaga 3. 

##   income median_income income_normalized
## 1  22000         21100         1.0426540
## 2  23200         21100         1.0995261
## 3  21000         21100         0.9952607
## 4  37770         21100         1.7900474
## 5  39000         21100         1.8483412
## 6  11100         21100         0.5260664

summary(training_prepared$income_normalized)

##    Min. 1st Qu.  Median    Mean 3rd Qu.    Max. 
##  0.0000  0.4049  1.0000  1.5685  1.9627 46.5556

# Uwaga 1. 
#   Jeeli pobrae katalog PDSwR2, to plik median_income.RDS znajdziesz w podkatalogu PDSwR2/Custdata. Zakadamy tu, e jest to Twj katalog roboczy. 

# Uwaga 2. 
#   czy median_income_table z danymi klientw, dziki czemu moesz znormalizowa dochody kadej osoby na podstawie mediany dochodw z waciwego stanu. 

# Uwaga 3. 
#   Porwnuje wartoci zmiennych income i income_normalized. 

