# przykad 2.8 z punktu 2.3.1 
# (przykad 2.8 z punktu 2.3.1)  : Wprowadzenie do jzyka R i danych : Praca z relacyjnymi bazami danych : Przykadowe dane o rozmiarze produkcyjnym 
# Tytu: Wczytywanie danych do R z relacyjnej bazy danych 

library("DBI")
library("dplyr")                                    	# Uwaga 1. 
library("rquery")

dlist <- readRDS("PUMS/PUMSsample.RDS")                   	# Uwaga 2. 
db <- dbConnect(RSQLite::SQLite(), ":memory:")      	# Uwaga 3. 
dbWriteTable(db, "dpus", as.data.frame(dlist$ss16pus)) 	# Uwaga 4. 
dbWriteTable(db, "dhus", as.data.frame(dlist$ss16hus))
rm(list = "dlist")                                  	# Uwaga 5. 

dbGetQuery(db, "SELECT * FROM dpus LIMIT 5")            	# Uwaga 6. 

dpus <- tbl(db, "dpus")                         	# Uwaga 7. 
dhus <- tbl(db, "dhus")

print(dpus)                                              	# Uwaga 8. 
glimpse(dpus)

View(rsummary(db, "dpus"))                     	# Uwaga 9.

# Uwaga 1. 
#   Importuje pakiety zawierajce funkcje i polecenia, z ktrych bdziemy korzysta. 

# Uwaga 2. 
#   Wczytuje dane z formatu RDS do pamici R. Uwaga: musisz zmieni ciek do pliku PUMSproba (w oryginale PUMSsample) na adres, pod ktrym przechowujesz katalog PUMS. 

# Uwaga 3. 
#   czy si z now baz danych RSQLite przechowywan w pamici. Bdziemy z niej korzysta w naszych przykadach. W praktyce czymy si zazwyczaj z istniejc baz danych, tak jak PostgreSQL czy Spark, zawierajc istniejce tablice. 

# Uwaga 4. 
#   Kopiuje dane ze struktury dlist przechowywanej w pamici do bazy danych. 

# Uwaga 5. 
#   Usuwa kopi lokaln naszych danych, poniewa symulujemy korzystanie z danych znalezionych w bazie danych. 

# Uwaga 6. 
#   Wykorzystuje jzyk kwerend SQL do szybkiego przejrzenia piciu rzdw danych. 

# Uwaga 7. 
#   Tworzy uchwyty pakietu dplyr odnoszce si do zdalnych danych bazodanowych. 

# Uwaga 8. 
#   Wykorzystuje pakiet dplyr do eksplorowania danych i pracy z nimi. 

# Uwaga 9. 
#   Wykorzystuje pakiet rquery do utworzenia podsumowania zdalnych danych. 

