
# plumber.R
# pakiet: https://CRAN.R-project.org/package=plumber 
# ten przykład: https://github.com/WinVector/PDSwR2/tree/master/Buzz

library("randomForest")

lst <- readRDS("thRS500.RDS")
varslist <- lst$varslist
fmodel <- lst$fmodel
buzztest <- lst$buzztest
rm(list = "lst")



#* Oblicza ocenę ramki danych
#* @param d oceniana ramka danych 
#* @post /score_data
function(d) { 	
  predict(fmodel, newdata = d, type = "prob")
}

#* Wyświetla kolumnę i-tego rzędu próby danych.
#* @param i indeks rzędu
#* @param col nazwa kolumny
#* @post /show_row_i_col
function(i, col) { 	
  buzztest[i, col, drop = TRUE]
}

#* Ocenia i-ty rząd próby danych.
#* @param i indeks rzędu
#* @post /score_row_i
function(i) { 	
  dat <- buzztest[i, ]
  predict(fmodel, newdata = dat, type = "prob")
}

#* Ocenia i-ty rz±d próby danych przy uwzględnieniu zmodyfikowanej zmiennej objaśniającej.
#* @param i indeks rzędu
#* @param col nazwa kolumny
#* @param newval nowa wartość kolumny col
#* @post /score_row_i_modified
function(i, col, newval) { 	
  dat <- buzztest[i, ]
  dat[1, col] <- newval
  predict(fmodel, newdata = dat, type = "prob")
}

# # Variable importances:
# head(imp[order(-imp$MeanDecreaseAccuracy), , drop = FALSE])
## 0        1 MeanDecreaseAccuracy MeanDecreaseGini
## num.displays_07 13.97224 20.54069             21.44778         250.4222

# Aby skorzystać z serwera:
#  użyj pliku RCurl_klient_przyklad.Rmd
#
#
# # Lub w powłoce Bash:
# curl --data '{"i":1}' http://localhost:8000/score_row_i
## [[0.99,0.01]]
# curl --data '{"i":1, "col":"num.displays_01"}' http://localhost:8000/show_row_i_col
## [1108]
# curl --data '{"i":1, "col":"num.displays_01", "newval":0}' http://localhost:8000/score_row_i_modified
## [[0.968,0.032]]


