load("Bookdata/bxBooks.RData")
colnames(bxBooks) <- gsub(".", "_", colnames(bxBooks), fixed=T)
colnames(bxBookRatings) <- gsub(".", "_", colnames(bxBookRatings), fixed=T)
colnames(bxUsers) <- gsub(".", "_", colnames(bxUsers), fixed=T)

Sys.setlocale('LC_ALL','C') # rozwizuje kwesti nieamerykaskich znakw diakrytycznych
# usuwa nawiasy i inne informacje dodatkowe najczciej spotykane
# na kocu tytuu. Najpierw usuwa nawias otwierajcy.
booktokens <- gsub("(", "#", bxBooks$Book_Title, fixed=T)
booktokens <- gsub("^#", "(", booktokens)
booktokens <- gsub("#.*$", "", booktokens) # Pozostawia odstp kocowy
cleantitles <- sub("[[:space:]]+$","",booktokens) # Zachowuje je

booktokens <- tolower(cleantitles)
Books <- data.frame(ISBN=bxBooks$ISBN, token=booktokens, title=cleantitles)

library(sqldf)
# Wybiera niepowtarzalny identyfikator ISBN dla kaego tokena -- jest to liczba niepowtarzalnych tokenw
bookmap <- sqldf('SELECT min(ISBN) as misbn,
                        token 
                 FROM Books
                 GROUP BY token')

# Zmienna displaymap przechowuje tytu dla kadego niepowtarzalnego tokena.
displaymap <- sqldf('SELECT Books.title as title,
                           bookmap.token as token
                   FROM Books,
                        bookmap
                   WHERE Books.ISBN=bookmap.misbn')

# Zmienna bookdata1 jest krtsza od zmiennej bxBookRatings, poniewa
#  niektre ocenione ksiki nie znajduj si w danych bxBooks
bookdata1 <- sqldf('SELECT ratings.User_ID as userid,
                         Books.token as token,
                         ratings.Book_Rating as rating
                  FROM Books,
                       bxBookRatings as ratings
                  WHERE ratings.ISBN=Books.ISBN')

# Dodaje wywietlan nazw
bookdata <- merge(bookdata1, displaymap, by="token")

write.table(bookdata, file="bookdata.tsv",
            sep="\t", row.names=F, col.names=T)

