# przykad 8.1 z punktu 8.2.1 
# (eprzykad 8.1 z punktu 8.2.1)  : Zaawansowane przygotowywanie danych : Konkurs KDD i zestaw danych KDD Cup 2009 : Pierwsze kroki z danymi KDD Cup 2009 
# Tytu: Przygotowanie danych KDD do analizy  

d <- read.table('KDD2009/orange_small_train.data.gz',             	# Uwaga 1. 
                header = TRUE,
                sep = '\t',
                na.strings = c('NA', ''))                                  	# Uwaga 2. 

churn <- read.table('KDD2009/orange_small_train_churn.labels.txt',
                    header = FALSE, sep = '\t')                             	# Uwaga 3.
d$churn <- churn$V1                                     	# Uwaga 4. 

set.seed(729375)                                         	# Uwaga 5. 
rgroup <- base::sample(c('train', 'calibrate', 'test'), 	# Uwaga 6.
                       nrow(d), 
                       prob = c(0.8, 0.1, 0.1),
                       replace = TRUE)
dTrain <- d[rgroup == 'train', , drop = FALSE]
dCal <- d[rgroup == 'calibrate', , drop = FALSE]
dTrainAll <- d[rgroup %in% c('train', 'calibrate'), , drop = FALSE]
dTest <- d[rgroup == 'test', , drop = FALSE]

outcome <- 'churn' 
vars <- setdiff(colnames(dTrainAll), outcome)

rm(list=c('d', 'churn', 'rgroup'))                         	# Uwaga 7.

# Uwaga 1. 
#   Wczytuje plik zawierajcy zmienne niezalene. Wszystkie dane s dostpne na stronie https://github.com/WinVector/PDSwR2/tree/master/KDD2009. 

# Uwaga 2. 
#   Traktuje wszystkie wartoci NA i puste acuchy znakw jako brakujce dane. 

# Uwaga 3. 
#   Odczytuje znane wyniki odpywu. 

# Uwaga 4. 
#   Dodaje odpyw jako now kolumn. 

# Uwaga 5. 
#   Dziki wyznaczeniu ziarna generatora liczb pseudolosowych sprawiamy, e nasz model bdzie odtwarzalny: inna osoba realizujca kod bdzie otrzymywaa dokadnie te same wyniki. 

# Uwaga 6. 
#   Dzieli dane na zbiory uczcy, kalibracyjny i testowy. Jawnie wyznacza funkcj base::sample() po to, aby unikn konfliktu z funkcj dplyr::sample() w przypadku, gdyby pakiet dplyr by wczytany. 

# Uwaga 7. 
#   Usuwa niepotrzebne obiekty z przestrzeni roboczej. 

