# przykad 6.5 z punktu 6.2.3 
# (przykad 6.5 z punktu 6.2.3)  : Wybr i ocena modeli : Ocenianie modeli : Ocenianie modeli klasyfikacyjnych 
# Tytu: Obserwacja zmiany wydajnoci filtra spamu pod wpywem zmiany proporcji spamu 

set.seed(234641)

N <- nrow(spamTest)
pull_out_ix <- sample.int(N, 100, replace=FALSE)
removed = spamTest[pull_out_ix,]                        	# Uwaga 1. 


get_performance <- function(sTest) {                    	# Uwaga 2.
  proportion <- mean(sTest$spam == "spam")
  confmat_spam <- table(truth = sTest$spam,
                        prediction = ifelse(sTest$pred>0.5, 
                                            "spam",
                                            "non-spam"))
  
  precision <- confmat_spam[2,2]/sum(confmat_spam[,2])
  recall <- confmat_spam[2,2]/sum(confmat_spam[2,])
  list(spam_proportion = proportion,
       confmat_spam = confmat_spam,
       precision = precision, recall = recall)
}


sTest <- spamTest[-pull_out_ix,]                  	# Uwaga 3. 
get_performance(sTest)

## $spam_proportion
## [1] 0.3994413
## 
## $confmat_spam
##           prediction
## truth      non-spam spam
##   non-spam      204   11
##   spam           17  126
## 
## $precision
## [1] 0.919708
## 
## $recall
## [1] 0.8811189

get_performance(rbind(sTest, subset(removed, spam=="spam")))  	# Uwaga 4. 

## $spam_proportion
## [1] 0.4556962
## 
## $confmat_spam
##           prediction
## truth      non-spam spam
##   non-spam      204   11
##   spam           22  158
## 
## $precision
## [1] 0.9349112
## 
## $recall
## [1] 0.8777778

get_performance(rbind(sTest, subset(removed, spam=="non-spam")))   	# Uwaga 5. 

## $spam_proportion
## [1] 0.3396675
## 
## $confmat_spam
##           prediction
## truth      non-spam spam
##   non-spam      264   14
##   spam           17  126
## 
## $precision
## [1] 0.9
## 
## $recall
## [1] 0.8811189

# Uwaga 1. 
#   Losowo usuwa 100 wiadomoci ze zbioru testowego. 

# Uwaga 2. 
#   Dodatkowa funkcja, wywietlajca macierz pomyek, precyzj i peno filtra dla zbioru testowego. 

# Uwaga 3. 
#   Sprawdza wydajno dla zbioru testowego zawierajcego tak sam proporcj spamu, jaka jest w zbiorze uczcym. 

# Uwaga 4. 
#   Dodaje jedynie spam, dziki czemu zbir testowy zawiera wiksz proporcj spamu w porwnaniu ze zbiorem uczcym. 

# Uwaga 5. 
#   Dodaje jedynie zwyke wiadomoci, dziki czemu zbir testowy zawiera mniejsz proporcj spamu w porwnaniu ze zbiorem uczcym.  

