#
# Jest to definicja interfejsu użytkownika w aplikacji sieciowej Shiny. Możesz uruchomić 
# aplikację poprzez kliknięcie przycisku 'Run App' znajdującego się ponad kodem.
#
# Więcej informacji na temat tworzenia aplikacji wykorzystujących Shiny znajdziesz tutaj:
# 
#    http://shiny.rstudio.com/
#

library(shiny)
library(shinythemes) # aby mieć dostęp do ciekawych motywów

# Definiuje interfejs aplikacji 
shinyUI(fluidPage(
  
  theme = shinytheme("simplex"),
  # Tytuł aplikacji
  titlePanel("Eksplorator progu"),
  
  # Pasek boczny z suwakiem umożliwiającym wybór progu
  sidebarLayout(
    sidebarPanel(
       sliderInput("threshold",
                   "Próg:",
                   min = 0,
                   max = 1,
                   value = 0.5),
       # a tutaj jest rzeczywisty wynik
       h4(textOutput("label", container = span))
    ),
    
    # Ukazuje wskaźniki wydajności w funkcji progu
    mainPanel(
       h4("Macierz pomyłek"),
       tableOutput("confusionMatrix"),
  #     h4("Wskaźniki dokładności"),
       tableOutput("performanceTable")
    )
  )
))
