

# Przykładowe kod i dane współtowarzyszące książce "Język R i analiza danych w praktyce. Wydanie II" autorstwa Niny Zumel i Johna Mounta, Helion 2021.


* Książka (wersja angielska): ["Practical Data Science with R, 2nd Edition" autorstwa Niny Zumel i Johna Mounta, Manning 2019](http://practicaldatascience.com/) (prawa autorskie należą do wydawnictwa Manning Publications Co.; wszystkie prawa zastrzeżone)
* Strona z materiałami dodatkowymi (wersja oryginalna): [GitHub WinVector/PDSwR2](https://github.com/WinVector/PDSwR2)


## Fragment książki, dla którego przeznaczone są zawarte w tym katalogu kod i dane:
 * Dodatek A. Korzystanie z R i innych narzędzi

# Przykład użycia języka SQL w środowisku knitr Markdown

Materiał pochodzi z [archiwum przykładów współtowarzyszących ksiażce "Praktyczna analiza danych z R", dostępnych w serwisie GitHub](https://github.com/WinVector/PDSwR2/).


 * rozpoczynami od plików CZYTAJ.Rmd i Arkusz1.xlsx
 * wygeneruj pliki CZYTAJ.md, HotelRelacja.pdf i katalog rysunki/* za pomocą polecenia "knit('CZYTAJ.Rmd')" w R
 * wygeneruj plik CZYTAJ.html za pomocą polecenia "pandoc CZYTAJ.md -o CZYTAJ.html" w powłoce bash
 * wszystkie te czynności możesz zrealizować za jednym zamachem w powłoce bash: echo "library('knitr'); knit('CZYTAJ.Rmd')" | R --vanilla ; pandoc CZYTAJ.md -o CZYTAJ.html


```r
library('xlsx')
```

```
## Loading required package: xlsxjars
## Loading required package: rJava
```

```r
bookings <- read.xlsx('Arkusz1.xlsx',1,startRow=3)
prices <- read.xlsx('Arkusz1.xlsx',2,startRow=3)

library('reshape2')
bthin <- melt(bookings,id.vars=c('date'),
   variable.name='daysBefore',value.name='bookings')
pthin <- melt(prices,id.vars=c('date'),
   variable.name='daysBefore',value.name='price')

daysCodes <- c('day.of.stay', 'X1.before', 'X2.before', 'X3.before')
bthin$nDaysBefore <- match(bthin$daysBefore,daysCodes)-1
pthin$nDaysBefore <- match(pthin$daysBefore,daysCodes)-1

# blokuje sqldf przed uruchomieniem zależności tcl/tk
# zobacz: https://code.google.com/p/sqldf/Troubleshooting
options(gsubfn.engine = "R")
library('sqldf')
```

```
## Loading required package: DBI
## Loading required package: gsubfn
## Loading required package: proto
## Loading required package: chron
## Loading required package: RSQLite
## Loading required package: RSQLite.extfuns
```

```r
joined <- sqldf('
  select
     bCurrent.date as StayDate,
     bCurrent.daysBefore as daysBefore,
     bCurrent.nDaysBefore as nDaysBefore,
     p.price as price,
     bCurrent.bookings as bookingsCurrent,
     bPrevious.bookings as bookingsPrevious,
     bCurrent.bookings - bPrevious.bookings as pickup
  from
     bthin bCurrent
  join
     bthin bPrevious
  on
     bCurrent.date=bPrevious.date
     and bCurrent.nDaysBefore+1=bPrevious.nDaysBefore
  join
     pthin p
  on
     bCurrent.date=p.date
     and bCurrent.nDaysBefore=p.nDaysBefore
')

library('ggplot2')
plt <- ggplot(data=joined,aes(x=price,y=pickup)) +
  geom_point() + geom_jitter() + geom_smooth(method='lm')
print(plt)
```

![wykres wszystkich etapów](rysunki/wszystkieetapy.png) 

```r
ggsave(filename='HotelRelacja.pdf',plot=plt)
```

```
## Saving 7 x 7 in image
```

```r

print(summary(lm(pickup~price,data=joined)))
```

```
## 
## Call:
## lm(formula = pickup ~ price, data = joined)
## 
## Residuals:
##    Min     1Q Median     3Q    Max 
##  -4.62  -2.81  -1.21   3.39   6.38 
## 
## Coefficients:
##             Estimate Std. Error t value Pr(>|t|)
## (Intercept)  11.0077     7.9874    1.38      0.2
## price        -0.0280     0.0319   -0.88      0.4
## 
## Residual standard error: 4.21 on 10 degrees of freedom
## Multiple R-squared:  0.0714,	Adjusted R-squared:  -0.0214 
## F-statistic: 0.769 on 1 and 10 DF,  p-value: 0.401
```


## Licencja obejmująca kod: 

<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/deed.pl"><img alt="Creative Commons License" style="border-width:0" src="http://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />Niniejsze dzieło jest objęte licencją <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Uznanie autorstwa - Użycie niekomercyjne - Na tych samych warunkach 4.0 Międzynarodowe</a>.
