# przykad B.5 z punktu B.1.3 
# (przykad B.5 z punktu B.1.3)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad logarytmicznie normalny 
# Tytu: Niektre wasnoci rozkadu logarytmicznie normalnego  

# losuje 1001 prb z rozkadu logarytmicznie normalnego (meanlog = 0, sdlog = 1)
u <- rlnorm(1001)

# rednia u jest wiksza od mediany
mean(u)
# [1] 1.638628
median(u)
# [1] 1.001051

# rednia log(u) jest w przyblieniu taka sama, jak meanlog=0
mean(log(u))
# [1] -0.002942916

# odchylenie standardowe log(u) wynosi mniej wicej sdlog=1
sd(log(u))
# [1] 0.9820357

# generuje rozkad logarytmicznie normalny (meanlog = 0, sdlog = 1)
x <- seq(from = 0, to = 25, length.out = 500)
f <- dlnorm(x)

# generuje rozkad normalny (mean = 0, sd = 1)
x2 <- seq(from = -5, to = 5, length.out = 500)
f2 <- dnorm(x2)

# tworzy ramki danych
lnormframe <- data.frame(x = x, y = f)
normframe <- data.frame(x = x2, y = f2)
dframe <- data.frame(u=u)

# tworzy wykresy gstoci z naoonymi krzywymi teoretycznymi
p1 <- ggplot(dframe, aes(x = u)) + geom_density() +
  geom_line(data = lnormframe, aes(x = x, y = y), linetype = 2)

p2 <- ggplot(dframe, aes(x = log(u))) + geom_density() +
  geom_line(data = normframe, aes(x = x,y = y), linetype = 2)

# funkcje umoliwiajce rysowanie wielu wykresw na jednej stronie
library(grid)
nplot <- function(plist) {
  n <- length(plist)
  grid.newpage()
  pushViewport(viewport(layout=grid.layout(n, 1)))
  vplayout<-function(x,y) { viewport(layout.pos.row = x, layout.pos.col = y) }
  for(i in 1:n) {
    print(plist[[i]], vp = vplayout(i, 1))
  }
}

# gwny wykres w tym punkcie
nplot(list(p1, p2))

