# przykad 7.32 z punktu 7.3.3 
# (przykad 7.32 z punktu 7.3.3)  : Regresja liniowa i logistyczna : Regularyzacja : Regresja regularyzowana przy uyciu pakietu glmnet 
# Tytu: Wyszukiwanie parametru alpha modelu o minimalnym bdzie 

get_cvm <- function(model) {                                  	# Uwaga 1. 
  index <- match(model$lambda.1se, model$lambda)
  model$cvm[index]
}

enet_performance <- data.frame(alpha = elastic_net$alpha)     	# Uwaga 2. 
models <- elastic_net$modlist                                 	# Uwaga 3. 
enet_performance$cvm <- vapply(models, get_cvm, numeric(1))  	# Uwaga 4.  

minix <- which.min(enet_performance$cvm)                     	# Uwaga 5.
(best_alpha <- elastic_net$alpha[minix])                     	# Uwaga 6. 
## [1] 0.729

ggplot(enet_performance, aes(x = alpha, y = cvm)) +          	# Uwaga 7. 
  geom_point() + 
  geom_line() + 
  geom_vline(xintercept = best_alpha, color = "red", linetype = 2) + 
  ggtitle("Funkcja straty kroswalidacji jako funkcja parametru alfa")

# Uwaga 1. 
#   Funkcja pozwalajca uzyska redni bd kroswalidacji modelu cv.glmnet lambda.lse.

# Uwaga 2. 
#   Uzyskuje wartoci parametru alpha wyprbowane przez algorytm. 

# Uwaga 3. 
#   Uzyskuje wygenerowane obiekty modelu. 

# Uwaga 4. 
#   Uzyskuje bdy kadego najlepszego modelu.

# Uwaga 5. 
#   Wyszukuje minimalny bd kroswalidacji. 

# Uwaga 6. 
#   Otrzymuje powizan warto parametru alpha. 

# Uwaga 7. 
#   Tworzy wykres wydajnoci modelu w funkcji parametru alpha. 

