#
# Skrypt tworzący przykładowe pliki danych na potrzeby projektu opisanego
# w podpunkcie 6.3.3 książki "Język R i analiza danych w praktyce. Wydanie II"
#

# Korpus IMDB: http://s3.amazonaws.com/text-datasets/aclImdb.zip
# 50,000 recenzji z serwisu Internet Movie Database.
# Skrypt wydobywający stworzony na podstawie listingu 6.8
# z książki Deep Learning. Praca z językiem R i biblioteką Keras, Francois Chollet, J.J. Allaire, Helion 2019
#
# aby uruchomić skrypt: rozpakuj plik aclImdb.zip w katalogu roboczym

library(zeallot)

getdata = function(dir) {
  labels <- c()
  texts <- c()
  for (label_type in c("neg", "pos")) {
    label <- switch(label_type, neg = 0, pos = 1)
    dir_name <- file.path(dir, label_type)
    for (fname in list.files(dir_name, pattern = glob2rx("*.txt"),
                             full.names = TRUE)) {
      texts <- c(texts, readChar(fname, file.info(fname)$size))
      labels <- c(labels, label)
    }
  }
  list(texts = texts, labels=labels)
}


#
#  zbiór uczący
#

imdb_dir <- "aclImdb"
train_dir <- file.path(imdb_dir, "train")
c(texts, labels) %<-% getdata(train_dir)

# nadaje nazwy tekstom i etykietom
n <- length(texts)
ids <- paste0("train_", 1:n)
names(texts) <- ids
names(labels) <- ids

# miesza dane (konfiguracja domyślna: najpierw negatywne, następnie pozytywne)
set.seed(241397)
ix <- sample.int(n, size=n, replace=FALSE)
texts <- texts[ix]
labels <- labels[ix]

IMDBtrain <- list(texts, labels)

#
# zbiór testowy
#

test_dir <- file.path(imdb_dir, "test")
c(test_txt, test_labels) %<-% getdata(test_dir)

# nadaje nazwy
ntest <- length(test_txt)
ids <- paste0("test_", 1:ntest)
names(test_txt) <- ids; names(test_labels) <- ids

IMDBtest <- list(test_txt, test_labels)

saveRDS(IMDBtrain, file="IMDBtrain.RDS")
saveRDS(IMDBtest, file="IMDBtest.RDS")
