

# Przykładowe kod i dane współtowarzyszące książce "Język R i analiza danych w praktyce. Wydanie II" autorstwa Niny Zumel i Johna Mounta, Helion 2021.


* Książka (wersja angielska): ["Practical Data Science with R, 2nd Edition" autorstwa Niny Zumel i Johna Mounta, Manning 2019](http://practicaldatascience.com/) (prawa autorskie należą do wydawnictwa Manning Publications Co.; wszystkie prawa zastrzeżone)
 * Strona z materiałami dodatkowymi (wersja oryginalna): [GitHub WinVector/PDSwR2](https://github.com/WinVector/PDSwR2)


## Fragment książki, dla którego przeznaczone są zawarte w tym katalogu kod i dane:
 * Rozdział 7. Regresja liniowa i logistyczna
 * Rozdział 10. Zaawansowane metody uczenia maszynowego
 * Rozdział 11. Dokumentowanie i wdrażanie


### Nasze projekty


Procedury przygotowujące dane. Uwaga: nie musisz wykonywać tych czynności, ponieważ zapisaliśmy dane w plikach ".Rdata" w tym katalogu. Operacje pobierania i wczytywania danych nie są potrzebne w dalszej części książki.

Dane zostały pierwotnie pobrane dnia 25.04.2013r. ze strony [http://www.cdc.gov/nchs/data_access/Vitalstatsonline.htm](http://www.cdc.gov/nchs/data_access/Vitalstatsonline.htm)

 * [ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/Dataset_Documentation/DVS/natality/UserGuide2010.pdf](ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/Dataset_Documentation/DVS/natality/UserGuide2010.pdf)
 * Shasum: 12520b8384defc63a93fad957936fd7ee9a42ef3  UserGuide2010.pdf
 * [ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/Datasets/DVS/natality/Nat2010us.zip](ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/Datasets/DVS/natality/Nat2010us.zip)
 * Shasum: dad8b9fc9e8b4a4d250b7febf10d4b97350e2651  Nat2010us.zip

Rozpakuj najpierw dane i skompresuj plik DAT w formacie gzip (R bez problemu odczytuje pliki umieszczone w archiwum Gzip):

```bash
  unzip Nat2010us.zip
  gzip -9 VS2010NATL.DETAILUS.DAT 
```


Zdefiniuj źródło danych (plik VS2010NATL.DETAILUS.DAT zawiera "stałe pola", gdzie dane występują w ściśle określonych pozycjach kolumn, natomiast plik fieldRanges.tsv stanowi naszą bieżącą definicję wygenerowaną poprzez edytowanie informacji wydobytych z definicji danych w formacie PDF).

 *  fieldRanges.tsv

Zdefiniujmy poświadczenia bazy danych H2:

 *  dbDef.xml

Wczytaj dane "o stałych polach" do bazy danych H2 za pomocą mechanizmu SQLScrewdriver:
```bash
  java -cp SQLScrewdriver.jar:h2-1.3.170.jar -Xmx1G com.winvector.db.LoadFFF file:dbDef.xml file:fieldRanges.tsv natal file:VS2010NATL.DETAILUS.DAT.gz
```

(Uwaga: użytkownicy systemu Windows muszą zastąpić znak rozdzielania elementów ścieżki do klas ":" znakiem ";"). W ten sposób zostaje wygenerowana baza danych H2 o nazwie NATAL.db, którą wykorzystamy w R w następujący sposób:


Z poziomu R uzyskujemy próbę danych w celu wygenerowania pliku natal2010Proba.tsv (na jego podstawie będziemy realizować wszystkie pozostałe etapy).

```R
options( java.parameters = "-Xmx2g" )
library(RJDBC)
drv <- JDBC("org.h2.Driver","h2-1.3.170.jar",identifier.quote="'")
options <- ";LOG=0;CACHE_SIZE=65536;LOCK_MODE=0;UNDO_LOG=0"
conn <- dbConnect(drv,paste("jdbc:h2:NATAL",options,sep=''),"u","u")
d <- dbGetQuery(conn,"SELECT * FROM natal WHERE ORIGRANDGROUP<=10")
dbDisconnect(conn)
write.table(d,'natal2010Proba.tsv',quote=F,sep='\t',col.names=T,row.names=F)
# gzip -9 natal2010Proba.tsv
# przekształca wartość 99 na wartość NA w kolumnie APGAR5
```

Po uzyskaniu próby danych natal2010Proba.tsv możemy przygotować dane do dalszej analizy (aktualne etapy przygotowawcze zostały opisane w plikach PrzygDanychRyzykoPolog.R i PrzygDanychWagaNoworod.R).

```R
d <- read.table('natal2010Proba.tsv.gz',sep='\t',header=T,stringsAsFactors=F)
# Łączy rzadkie przypadki czworaczków i większej liczby wieloraczków z trojaczkami
d$DPLURAL = pmin(d$DPLURAL,3)
# Przekodowuje wartości nieznane w kolumnie wynikowej
d$APGAR5[d$APGAR5==99] <- NA
# przekodowuje U jako wartość nieznaną w kolumnach ryzyka
#factorCols <- c('RF_DIAB','RF_GEST','RF_PHYP','RF_GHYP','RF_ECLAM','RF_PPTERM','RF_PPOUTC', 'CIG_REC', 'DPLURAL', 'GESTREC3', 'PRECARE_REC')
factorCols <- c('CIG_REC', 'DPLURAL', 'GESTREC3', 'PRECARE_REC')
lapply(subset(d,,select=factorCols),
   function(col) summary(as.factor(col)))
for(colName in factorCols) {
  d[,colName] <- factor(ifelse(d[,colName] %in% list('','U'),NA,d[,colName]))
}
numCols <- c('DWGT')
for(colName in numCols) {
  d[,colName] <- ifelse(d[,colName] >=999,NA,d[,colName])
}
#d$atRisk <- d$BWTR4<2 | d$APGAR5<7
d$atRisk <- d$APGAR5<7
riskCols <- c(factorCols,numCols)
library(reshape2)
dTrain <- subset(d,ORIGRANDGROUP<=5)
dTest <- subset(d,ORIGRANDGROUP>5)
model <- glm(as.formula(paste('atRisk',paste(riskCols,collapse=' + '),sep=' ~ ')),
  data=dTrain,family=binomial(link='logit'))   
print(summary(model))
dTest$pred <- predict(model,newdata=dTest,type='response')
dplot <- subset(dTest,(!is.na(pred) & (!is.na(atRisk))))
ambientProb <- mean(dplot$atRisk)
table(pred=dplot$pred>=2*ambientProb,atRisk=dplot$atRisk)
```



## Licencja obejmująca dodatkowe dokumentację, uwagi, kod i dane pochodne: 

<a rel="license" href="https://creativecommons.org/licenses/by-nc-sa/4.0/deed.pl"><img alt="Creative Commons License" style="border-width:0" src="http://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />Niniejsze dzieło jest objęte licencją <a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">Uznanie autorstwa - Użycie niekomercyjne - Na tych samych warunkach 4.0 Międzynarodowe</a>.

Żaden z tych elementów nie jest objęty gwarancją, ubezpieczeniem ani roszczeniem działania.

Licencja nie obejmuje projektów osób trzecich ani danych pochodnych.
