Przykład oceniania szumu medialnego
================

Przykładowe ocenianie (uzyskiwanie przewidywań za pomocą) zestawu danych
Buzz.

Najpierw uaktywnij pakiet `randomForest` i wczytaj model oraz dane
testowe.

``` r
suppressPackageStartupMessages(library("randomForest"))
```

    ## Warning: package 'randomForest' was built under R version 4.0.3

``` r
lst <- readRDS("thRS500.RDS")
varslist <- lst$varslist
fmodel <- lst$fmodel
buzztest <- lst$buzztest
rm(list = "lst")
```

Sprawdźmy teraz jakość modelu na odłożonych danych testowych.

``` r
buzztest$prediction <- predict(fmodel, newdata = buzztest, type = "prob")[, 2, drop = TRUE]

WVPlots::ROCPlot(buzztest, "prediction", 
                 "buzz", 1, 
                 "Krzywa ROC oszacowująca jakość przewidywań modelu na odłożonych danych")
```

![](Buzz_ocena_przyklad_files/figure-gfm/unnamed-chunk-3-1.png)<!-- -->
