
#' Zwraca pseudologarytm dziesietny.
#'
#' Zwraca pseudologarytm (dziesietny) zmiennej x, co daje w przyblizeniu wartosc
#' sign(x)*log10(abs(x)) dla takiego x, ktorego abs(x) ma duza wartosc
#' i nie "eksploduje" w poblizu zera.  Rozwiazanie to przydaje sie
#' podczas przeksztalcania zmiennych o szerokim zakresie, ktore moga przyjmowac
#' wartosci ujemne (na przyklad zysk/strata).
#'
#' Zobacz: \url{http://www.win-vector.com/blog/2012/03/modeling-trick-the-signed-pseudo-logarithm/}
#'
#' Uwaga: z przeksztalceniem tym wiaze sie niepozadany skutek uboczny, w wyniku ktorego wiekszosc
#' rozkladow okreslonych znakiem wydaje sie byc bimodalnych w okolicach srodka ukladu wspolrzednych
#' bez wzgledu na rzeczywisty ksztalt rozkladu.
#' Zakladamy, ze argument x jest numeryczny i moze byc wektorem.
#'
#' @param x wektor numeryczny
#'
#' @return pseudologarytm dziesietny x
#'
#' @examples
#'
#' pseudoLog10(c(-5, 0, 5))
#' # powinienes otrzymac nastepujace wyniki: [1] -0.7153834  0.0000000  0.7153834
#'
#' @export
#'
pseudoLog10 <- function(x) {
  asinh(x / 2) / log(10)
}


