# przykad 10.1 z punktu 10.1.1 
# (przykad 10.1 z punktu 10.1.1)  : Zaawansowane metody uczenia maszynowego : Metody drzewa : Podstawowe drzewo decyzyjne 
# Tytu: Przygotowywanie danych Spambase i ocena modelu drzewa decyzyjnego 

spamD <- read.table('Spambase/spamD.tsv', header = TRUE, sep = '\t')    		#  Uwaga 1.
spamD$isSpam <- spamD$spam == 'spam'
spamTrain <- subset(spamD, spamD$rgroup >= 10)
spamTest <- subset(spamD, spamD$rgroup < 10)

spamVars <- setdiff(colnames(spamD), list('rgroup', 'spam', 'isSpam'))
library(wrapr)
spamFormula <- mk_formula("isSpam", spamVars)                        	# Uwaga 2. 

loglikelihood <- function(y, py) {                                     	# Uwaga 3. 
  pysmooth <- ifelse(py == 0, 1e-12,
                     ifelse(py == 1, 1 - 1e-12, py))
  
  sum(y * log(pysmooth) + (1 - y) * log(1 - pysmooth))
}


accuracyMeasures <- function(pred, truth, name = "model") {            	# Uwaga 4. 
  dev.norm <- -2 * loglikelihood(as.numeric(truth), pred) / length(pred)    	# Uwaga 5. 
  ctable <- table(truth = truth,
                  pred = (pred > 0.5))                                       	# Uwaga 6. 
  accuracy <- sum(diag(ctable)) / sum(ctable)
  precision <- ctable[2, 2] / sum(ctable[, 2])
  recall <- ctable[2, 2] / sum(ctable[2, ])
  f1 <- 2 * precision * recall / (precision + recall)
  data.frame(model = name, accuracy = accuracy, f1 = f1, dev.norm)
}


library(rpart)                                                              	# Uwaga 7. 
treemodel <- rpart(spamFormula, spamTrain, method = "class")

library(rpart.plot)                                                     	# Uwaga 8. 
rpart.plot(treemodel, type = 5, extra = 6)     

predTrain <- predict(treemodel, newdata = spamTrain)[, 2]                	# Uwaga 9. 

trainperf_tree <- accuracyMeasures(predTrain,                      		# Uwaga 10.  
                                   spamTrain$spam == "spam",
                                   name = "drzewo, uczacy")

predTest <- predict(treemodel, newdata = spamTest)[, 2]
testperf_tree <- accuracyMeasures(predTest,
                                  spamTest$spam == "spam",
                                  name = "drzewo, testowy")

# Uwaga 1. 
#   Wczytuje dane i rozdziela je na zbiory uczcy (90% danych) oraz testowy (10%). 

# Uwaga 2. 
#   Wykorzystuje wszystkie cechy i przeprowadza klasyfikacj binarn, gdzie TRUE oznacza spam. 

# Uwaga 3. 
#   Funkcja obliczajca logarytm wiarygodnoci (potrzebny do obliczenia dewiancji). 

# Uwaga 4. 
#   Funkcja obliczajca i zwracajca rne wskaniki modelu: znormalizowan dewiancj, dokadno predykcyjn i wynik f1. 

# Uwaga 5. 
#   Normalizuje dewiancj za pomoc liczby punktw danych, dziki czemu bdziemy mogli porwna j pomidzy zbiorem uczcym a testowym. 

# Uwaga 6. 
#   Przeksztaca estymator prawdopodobiestwa przynalenoci do klasy w klasyfikator poprzez oznaczanie dokumentw, dla ktrych ocena jako spam jest wiksza od 0,5.  

# Uwaga 7. 
#   Wczytuje bibliotek rpart i dopasowuje model drzewa decyzyjnego. 

# Uwaga 8. 
#   Do wygenerowania wykresu drzewa. 

# Uwaga 9. 
#   Uzyskuje przewidywane prawdopodobiestwa przynalenoci do klasy spam. 

# Uwaga 10. 
#   Ocenia model drzewa decyzyjnego w zbiorach uczcym i testowym. 

