# przykad 9.6 z punktu 9.1.3 
# (przykad 9.6 z punktu 9.1.3)  : Metody nienadzorowane : Analiza skupie : Hierarchiczna analiza skupie za pomoc funkcji hclust()  
# Tytu: Uycie funkcji clusterboot() na zestawie danych Protein 

library(fpc)                                                	# Uwaga 1. 
kbest_p <- 5                                                      	# Uwaga 2. 
cboot_hclust <- clusterboot(pmatrix,
                            clustermethod = hclustCBI,    	# Uwaga 3.  
                            method = "ward.D",
                            k = kbest_p)

summary(cboot_hclust$result)                               	# Uwaga 4. 

##               Length Class  Mode     
## result         7     hclust list     
## noise          1     -none- logical  
## nc             1     -none- numeric  
## clusterlist    5     -none- list     
## partition     25     -none- numeric  
## clustermethod  1     -none- character
## nccl           1     -none- numeric

groups <- cboot_hclust$result$partition                        	# Uwaga 5. 
print_clusters(protein, groups, cols_to_print)                               	# Uwaga 6. 

## $`1`
##       Country RedMeat Fish Fr.Veg
## 1     Albania    10.1  0.2    1.7
## 4    Bulgaria     7.8  1.2    4.2
## 18    Romania     6.2  1.0    2.8
## 25 Yugoslavia     4.4  0.6    3.2
## 
## $`2`
##        Country RedMeat Fish Fr.Veg
## 2      Austria     8.9  2.1    4.3
## 3      Belgium    13.5  4.5    4.0
## 9       France    18.0  5.7    6.5
## 12     Ireland    13.9  2.2    2.9
## 14 Netherlands     9.5  2.5    3.7
## 21 Switzerland    13.1  2.3    4.9
## 22          UK    17.4  4.3    3.3
## 24   W Germany    11.4  3.4    3.8
## 
## $`3`
##           Country RedMeat Fish Fr.Veg
## 5  Czechoslovakia     9.7  2.0    4.0
## 7       E Germany     8.4  5.4    3.6
## 11        Hungary     5.3  0.3    4.2
## 16         Poland     6.9  3.0    6.6
## 23           USSR     9.3  3.0    2.9
## 
## $`4`
##    Country RedMeat Fish Fr.Veg
## 6  Denmark    10.6  9.9    2.4
## 8  Finland     9.5  5.8    1.4
## 15  Norway     9.4  9.7    2.7
## 20  Sweden     9.9  7.5    2.0
## 
## $`5`
##     Country RedMeat Fish Fr.Veg
## 10   Greece    10.2  5.9    6.5
## 13    Italy     9.0  3.4    6.7
## 17 Portugal     6.2 14.2    7.9
## 19    Spain     7.1  7.0    7.2

cboot_hclust$bootmean                                       	# Uwaga 7. 
## [1] 0.8090000 0.7939643 0.6247976 0.9366667 0.7815000

cboot_hclust$bootbrd                                        	# Uwaga 8.
## [1] 19 14 45  9 30

# Uwaga 1. 
#   Wczytuje pakiet fpc. By moesz bdziesz go musia najpierw zainstalowa. 

# Uwaga 2. 
#   Wyznacza podan liczb skupie.

# Uwaga 3. 
#   Uruchamia funkcj clusterboot() z wyznaczonym algorytmem hclust (clustermethod = hclustCBI), metod Warda (method = "ward.D") i kbest_p skupieniami (k = kbest_p). Zwraca wyniki w obiekcie o nazwie cboot_hclust. 

# Uwaga 4. 
#   Rezultaty analizy skupie mieszcz si w zmiennej cboot_hclust$result. 

# Uwaga 5. 
#   Obiekt cboot_hclust$result$partition zwraca wektor etykiet skupie. 

# Uwaga 6. 
#   Skupienia s takie same jak te uzyskane za pomoc bezporedniego wywoania funkcji hclust(). 

# Uwaga 7. 
#   Wektor stabilnoci skupie. 

# Uwaga 8. 
#   Liczba przypadkw, w ktrych dane skupienie byo rozpuszczone. Domylnie funkcja clusterboot() realizuje 100 iteracji metody samowspornej. 

