# przykad 2.10 z punktu 2.3.1 
# (przykad 2.10 z punktu 2.3.1)  : Wprowadzenie do jzyka R i danych : Praca z relacyjnymi bazami danych : Przykadowe dane o rozmiarze produkcyjnym
# Tytu: Przemapowanie wartoci i wybieranie rzdw z danych 

target_emp_levs <- c(                                          	# Uwaga 1. 
  "Employee of a private for-profit company or busine",
  "Employee of a private not-for-profit, tax-exempt, ",
  "Federal government employee",                    
  "Local government employee (city, county, etc.)",   
  "Self-employed in own incorporated business, profes",
  "Self-employed in own not incorporated business, pr",
  "State government employee")


complete <- complete.cases(dpus)                              	# Uwaga 2. 

stdworker <- with(dpus,                                        	# Uwaga 3. 
                  (PINCP>1000) & 
                    (ESR=="Civilian employed, at work") & 
                    (PINCP<=250000) & 
                    (PERNP>1000) & (PERNP<=250000) & 
                    (WKHP>=30) & 
                    (AGEP>=18) & (AGEP<=65) & 
                    (COW %in% target_emp_levs))

dpus <- dpus[complete & stdworker, , drop = FALSE]              	# Uwaga 4. 

no_advanced_degree <- is.na(dpus$SCHL) |                     	# Uwaga 5. 
  (!(dpus$SCHL %in% c("Associate's degree",
                      "Bachelor's degree",
                      "Doctorate degree",
                      "Master's degree",
                      "Professional degree beyond a bachelor's degree")))
dpus$SCHL[no_advanced_degree] <- "No Advanced Degree"

dpus$SCHL <- relevel(factor(dpus$SCHL),                     	# Uwaga 6. 
                     "No Advanced Degree")                
dpus$COW <- relevel(factor(dpus$COW), 
                    target_emp_levs[[1]])
dpus$ESR <- relevel(factor(dpus$ESR), 
                    "Civilian employed, at work")
dpus$SEX <- relevel(factor(dpus$SEX), 
                    "Male")

saveRDS(dpus, "dpus_std_pracownik.RDS")                           	# Uwaga 7.  

summary(dpus)                                                  	# Uwaga 8.

# Uwaga 1. 
#   Definiuje wektor definicji zatrudnienia, ktre uznajemy za standardowe. 

# Uwaga 2. 
#   Tworzy nowy wektor logiczny wskazujcy, ktre rzdy maj waciwe wartoci we wszystkich interesujcych nas kolumnach. W rzeczywistych zastosowaniach istotna jest kwestia zajmowania si brakujcymi wartociami i nie zawsze mona j rozwiza poprzez pomijanie niepenych rzdw. Wrcimy do kwestii zajmowania si brakujcymi wartociami podczas omawiania tematu zarzdzania danymi.

# Uwaga 3. 
#   Tworzy nowy wektor logiczny wyznaczajcy osoby, ktre moemy uzna za typowych pracownikw penoetatowych. Nazwy wszystkich wymienionych tu kolumn zostay opisane w tekcie. Od podanej tu definicji zale wyniki dowolnej przeprowadzanej analizy, dlatego w rzeczywistym projekcie naley powici mnstwo czasu na dobr odpowiednich elementw. W tym miejscu dosownie okrelamy, kogo i co chcemy bada. Zwr uwag, e w celu zachowania przejrzystoci ograniczylimy analiz do cywilw, co w penoprawnej analizie stanowioby niedopuszczalne ograniczenie. 

# Uwaga 4. 
#   Ogranicza analiz wycznie do rzdw lub przykadw, ktre speniaj nasz definicj typowego pracownika. 

# Uwaga 5. 
#   Przeksztaca informacje o wyksztaceniu: scala poziomy wyksztacenia nisze od licencjata (ang. bachelor) w jeden poziom No Advanced Degree. 

# Uwaga 6. 
#   Przeksztaca kolumny przechowujce acuchy znakw w wektory czynnikowe i dobiera poziom referencyjny za pomoc funkcji relevel(). 

# Uwaga 7. 
#   Zapisuje te dane do pliku, dziki czemu bdziemy mogli je wykorzysta w innych przykadach. Plik ten jest rwnie dostpny pod adresem PDSwR2/PUMS/dpus_std_pracownik.RDS. 

# Uwaga 8. 
#   Wywietla informacje o naszych danych. Jedn z zalet wektorw czynnikowych jest fakt, e funkcja summary() generuje ich przydatne statystyki. Warto jednak zawsze poczeka z przeksztacaniem acuchw znakw w wektory czynnikowe a do zakoczenia operacji przemapowania kodw poziomw. 

