# przykad 10.7 z punktu 10.1.4 
# (przykad 10.7 z punktu 10.1.4)  : Zaawansowane metody uczenia maszynowego : Metody drzewa : Drzewa wzmacniane gradientowo 
# Tytu: Wykonanie sprawdzianu krzyowego w celu ustalenia rozmiaru modelu

library(xgboost)

cv <- xgb.cv(input,                                        	# Uwaga 1.  
             label = train$class,                           	# Uwaga 2.  
             params = list(
               objective = "binary:logistic"             	# Uwaga 3.
             ),
             nfold = 5,                                    	# Uwaga 4. 
             nrounds = 100,                                	# Uwaga 5. 
             print_every_n = 10,                           	# Uwaga 6. 
             metrics = "logloss")                      	# Uwaga 7.  

evalframe <- as.data.frame(cv$evaluation_log)               	# Uwaga 8.  
head(evalframe)                                              	# Uwaga 9.  

##   iter train_logloss_mean train_logloss_std test_logloss_mean
## 1    1          0.4547800      7.758350e-05         0.4550578
## 2    2          0.3175798      9.268527e-05         0.3179284
## 3    3          0.2294212      9.542411e-05         0.2297848
## 4    4          0.1696242      9.452492e-05         0.1699816
## 5    5          0.1277388      9.207258e-05         0.1280816
## 6    6          0.0977648      8.913899e-05         0.0980894
##   test_logloss_std
## 1      0.001638487
## 2      0.002056267
## 3      0.002142687
## 4      0.002107535
## 5      0.002020668
## 6      0.001911152

(NROUNDS <- which.min(evalframe$test_logloss_mean))        	# Uwaga 10. 
## [1] 18

library(ggplot2)
ggplot(evalframe, aes(x = iter, y = test_logloss_mean)) + 
  geom_line() + 
  geom_vline(xintercept = NROUNDS, color = "darkred", linetype = 2) + 
  ggtitle("Kroswalidowana logarytmiczna funkcja straty jako funkcja rozmiaru zespou")

# Uwaga 1. 
#   Macierz wejciowa. 

# Uwaga 2. 
#   Etykiety klasy, rwnie w postaci numerycznej (1 dla klasy setosa, 0 dla pozostaych). 

# Uwaga 3. 
#   Wykorzystuje funkcj celu "binary:logistic" do klasyfikacji binarnej, a "reg:linear" do regresji. 

# Uwaga 4. 
#   Wykorzystuje piciokrotny sprawdzian krzyowy. 

# Uwaga 5. 
#   Tworzy zesp skadajcy si ze 100 drzew. 

# Uwaga 6. 
#   Wywietla komunikat co dziesit iteracj (jeeli nie chcesz komunikatw, wstaw verbose = FALSE).

# Uwaga 7. 
#   Wykorzystuje minimaln, kroswalidowan funkcj straty (powizan z dewiancj) do wyznaczenia optymalnej liczby drzew. W przypadku regresji stosowany jest wskanik metrics = "rmse". 

# Uwaga 8. 
#   Przygotowuje dziennik wydajnoci. 

# Uwaga 9. 
#   Obiekt evalframe rejestruje kroswalidowan funkcj straty dla zbioru uczcego jako funkcj liczby drzew. 

# Uwaga 10. 
#   Wyszukuje liczb drzew zapewniajc minimaln, kroswalidowan logarytmiczn funkcj straty. 

