# przykad 9.9 z punktu 9.1.3 
# (przykad 9.9 z punktu 9.1.3)  : Metody nienadzorowane : Analiza skupie : Hierarchiczna analiza skupie za pomoc funkcji hclust() 
# Tytu: Tworzenie wykresw sum BSS i WSS w funkcji k 

total_ss <- function(dmatrix) {                              	# Uwaga 1. 
  grandmean <- colMeans(dmatrix)
  sum(apply(dmatrix, 1, FUN = function(row) { sqr_edist(row, grandmean) }))
}

tss <- total_ss(pmatrix)
cluster_meas$bss <- with(cluster_meas, tss - wss)

library(cdata)                                                 	# Uwaga 2. 
cmlong <- unpivot_to_blocks(cluster_meas,                       	# Uwaga 3. 
                            nameForNewKeyColumn = "measure",
                            nameForNewValueColumn = "value",
                            columnsToTakeFrom = c("wss", "bss"))

ggplot(cmlong, aes(x = nclusters, y = value)) +  
  geom_point() + geom_line() + 
  facet_wrap(~measure, ncol = 1, scale = "free_y") +
  scale_x_continuous(breaks = 1:10)

# Uwaga 1. 
#   Oblicza cakowit sum kwadratw: TSS. 

# Uwaga 2. 
#   Wczytuje pakiet cdata, umoliwiajcy przeksztacenie danych.  

# Uwaga 3. 
#   Przeksztaca cluster_meas tak, e sumy WSS i BSS znajduj si w tej samej kolumnie. 

