# nieoficjalny przykad 5.69 z punktu 5.5.2 
# (nieoficjalny przykad 5.69 z punktu 5.5.2)  : Inynieria i ksztatowanie danych : Transformacje przestawiajce : Przenoszenie danych z formy wysokiej do szerokiej

library("ggplot2")

ChickSummary <- cdata::unpivot_to_blocks(                              	# Uwaga 1.
  ChickSummary,
  nameForNewKeyColumn = "measurement",
  nameForNewValueColumn = "value",
  columnsToTakeFrom = c("count", "weight"))

ChickSummary$q1_weight[ChickSummary$measurement=="count"] <- NA    	# Uwaga 2.
ChickSummary$q2_weight[ChickSummary$measurement=="count"] <- NA
CW <- ChickWeight
CW$measurement <- "weight"

ggplot(ChickSummary, aes(x = Time, y = value, color = measurement)) +   	# Uwaga 3. 
  geom_line(data = CW, aes(x = Time, y = weight, group = Chick),
            color="LightGray") +
  geom_line(size=2) + 
  geom_ribbon(aes(ymin = q1_weight, ymax = q2_weight), 
              alpha = 0.3, colour = NA) +
  facet_wrap(~measurement, ncol=1, scales = "free_y") +
  theme(legend.position = "none") +
  ylab(NULL) +
  ggtitle("Waga kurczakw (weight) i pomiary liczebnoci (count) w funkcji czasu",
          subtitle = "Kwartyle od 25% do 75% wagi zostay zacienione wok redniej")

# Uwaga 1. 
#   Przywraca dane do formy wysokiej. 

# Uwaga 2. 
#   Wyznacza dokadnie wymagany zbir kolumn do stworzenia wykresu. 

# Uwaga 3. 
#   Tworzy wykres.