# przykad B.9 z punktu B.1.4 
# (przykad B.9 z punktu B.1.4)  : Wane pojcia z dziedziny statystyki : Rozkady : Rozkad dwumianowy 
# Tytu: Symulowanie rozkadu dwumianowego

# za pomoc funkcji rbinom symuluje N rzutw monet o prawdopoddobiestwie p

p75 <- 0.75 # znacznie sfaszowana moneta (gwnie reszki)
N <- 1000  # wykonuje kilka rzutw
flips_v1 <- rbinom(N, 1, p75)

# Moemy rwnie wygenerowa rzuty faszyw monet za pomoc instrukcji runif:
# prawdopodobiestwo, e jednostajna liczba losowa z przedziau [0 1)
# jest mniejsza od p wynosi dokadnie p. Zatem "mniej ni p" oznacza "reszk".
flips_v2 <- as.numeric(runif(N) < p75) 

prettyprint_flips <- function(flips) {
  wynik <- ifelse(flips==1, "reszka", "orze")
  table(wynik)
}

prettyprint_flips(flips_v1)
# wynik
# orze reszka 
#   254    746 
prettyprint_flips(flips_v2)
# wynik
# orze reszka 
#   218    782

