# przykad 10.14 z punktu 10.2.2 
# (przykad 10.14 z punktu 10.2.2)  : Zaawansowane metody uczenia maszynowego : Wykrywanie relacji niemonotonicznych za pomoc uoglnionych modeli addytywnych : Przykad regresji jednowymiarowej 
# Tytu: Uycie modelu GAN w naszym przykadzie  

library(mgcv)                                   	# Uwaga 1.
gam_model <- gam(y ~ s(x), data = train)        	# Uwaga 2. 
gam_model$converged                             	# Uwaga 3. 
## [1] TRUE

summary(gam_model)

## Family: gaussian                                	# Uwaga 4. 
## Link function: identity
##
## Formula:
## y ~ s(x)
##
## Parametric coefficients:                       	# Uwaga 5. 
##             Estimate Std. Error t value Pr(>|t|)
## (Intercept) -0.83467    0.04852   -17.2   <2e-16 ***
## ---
## Signif. codes:  0 *** 0.001 ** 0.01 * 0.05 . 0.1   1
##
## Approximate significance of smooth terms:            	# Uwaga 6. 
##        edf Ref.df     F p-value
## s(x) 8.685  8.972 497.8  <2e-16 ***
## ---
## Signif. codes:  0 *** 0.001 ** 0.01 * 0.05 . 0.1   1
##
## R-sq.(adj) =  0.832   Deviance explained = 83.4%          	# Uwaga 7.  
## GCV score =  2.144  Scale est. = 2.121     n = 901

train$pred <- predict(gam_model, train)                	# Uwaga 8.
resid_gam <- with(train, y - pred)
rmse(resid_gam)

## [1] 1.448514

ggplot(train, aes(x = pred, y = y)) +                   	# Uwaga 9.
  geom_point(alpha = 0.3) + 
  geom_abline()

# Uwaga 1. 
#   Wczytuje pakiet mgcv. 

# Uwaga 2. 
#   Tworzy model przy zaoeniu, e zmienna x powinna by traktowana jako zmienna nieliniowa. 

# Uwaga 3. 
#   Parametr converged informuje nas, czy model osign zbieno. Naley ufa uzyskiwanym wynikom jedynie wtedy, gdy otrzymamy tu warto TRUE. 

# Uwaga 4. 
#   Wyznaczenie parametrw family = gaussian i link = identity mwi nam, e w modelu tym zostay przyjte takie same zaoenia rozkadu jak w standardowej regresji liniowej. 

# Uwaga 5. 
#   Wspczynniki parametryczne (ang. parametric coefficients) s czonami liniowymi (w tym przypadku jedynie czonem staym). W tej czci podsumowania dowiadujemy si, ktre czony liniowe rni si znacznie od zera. 

# Uwaga 6. 
#   Czony wygadzania (ang. smooth terms) s czonami nieliniowymi. W tej czci podsumowania dowiadujemy si, ktre czony nieliniowe znaczco odbiegaj od 0. Poznajemy tu take efektywne stopnie swobody (ang. effective degrees of freedom  edf), uyte do stworzenia poszczeglnych czonw wygadzania. Warto edf zbliona do 1 wskazuje na to, e relacja pomidzy dan zmienn a wynikiem jest niemal liniowa.  

# Uwaga 7. 
#   R-sq.(adj) to skorygowany wspczynnik determinacji. Z kolei Deviance explained zawieraj nieskorygowan warto wspczynnika determinacji (0,834).

# Uwaga 8. 
#   Oblicza bd RMSE tego modelu dla danych uczcych. 

# Uwaga 9. 
#   Tworzy wykres y w funkcji przewidywa. 

