# przykad 9.8 z punktu 9.1.3 
# (przykad 9.8 z punktu 9.1.3)  : Metody nienadzorowane : Analiza skupie : Hierarchiczna analiza skupie za pomoc funkcji hclust() 
# Tytu: Tworzenie wykresu sumy WSS dla zakresu wartoci k 

get_wss <- function(dmatrix, max_clusters) {       	# Uwaga 1. 
  wss = numeric(max_clusters)
  
  
  wss[1] <- wss_cluster(dmatrix)                  	# Uwaga 2. 
  
  d <- dist(dmatrix, method = "euclidean")
  pfit <- hclust(d, method = "ward.D")       	# Uwaga 3. 
  
  for(k in 2:max_clusters) {                     	# Uwaga 4.     
    labels <- cutree(pfit, k = k)
    wss[k] <- wss_total(dmatrix, labels)
  }
  
  wss
}

kmax <- 10
cluster_meas <- data.frame(nclusters = 1:kmax,
                           wss = get_wss(pmatrix, kmax))

breaks <- 1:kmax
ggplot(cluster_meas, aes(x=nclusters, y = wss)) +      	# Uwaga 5. 
  geom_point() + geom_line() +
  scale_x_continuous(breaks = breaks)

# Uwaga 1. 
#   Funkcja pozwalajca uzyska cakowit sum WSS dla zakresu skupie od 1 do ich maksymalnej liczby. 

# Uwaga 2. 
#   Za pomoc wss[1] otrzymujemy sum WSS dla wszystkich danych. 

# Uwaga 3. 
#   Tworzy skupienia danych. 

# Uwaga 4. 
#   Dla kadej wartoci k oblicza etykiety skupie i sum WSS skupienia. 

# Uwaga 5. 
#   Tworzy wykres sumy WSS w funkcji k. 

