# przykad 8.10 z punktu 8.6.6 
# (przykad 8.10 z punktu 8.6.6)  : Zaawansowane przygotowywanie danych : Opanowanie pakietu vtreat : Ramka krzyowa 
# Tytu: Korzystanie z funkcji mkCrossFrameNExperiment() 

cfe <- vtreat::mkCrossFrameNExperiment(d, 
                                       varlist = c("x_zla", "x_dobra"),
                                       outcomename = "y",
                                       codeRestriction = "catN",
                                       minFraction = 2,
                                       verbose = FALSE)
plan6 <- cfe$treatments

dane_uczace2 <- cfe$crossFrame
wyn2 <- vtreat::patch_columns_into_frame(d, dane_uczace2)

head(wyn2)
#   x_zla  x_dobra x_zla_catN x_dobra_catN           y
# 1     u  nie-neg  0.2834739    0.4193180 -0.05294738
# 2     s      neg -0.1085887   -0.6212118 -0.23639840
# 3     h  nie-neg  0.0000000    0.5095586 -0.33796351
# 4     q  nie-neg -0.5142570    0.5095586 -0.75548467
# 5     b      neg -0.3540889   -0.6212118 -0.86159347
# 6     b  nie-neg -0.3540889    0.4193180 -0.52766549

sigr::wrapFTest(wyn2, "x_zla_catN", "y")
# [1] "F Test summary: (R2=-0.1389, F(1,98)=-11.95, p=n.s.)."

sigr::wrapFTest(wyn2, "x_dobra_catN", "y")
# [1] "F Test summary: (R2=0.2532, F(1,98)=33.22, p<1e-05)."

plan6$scoreFrame                                               	# Uwaga 1. 
#        varName varMoves        rsq          sig needsSplit
# 1   x_zla_catN     TRUE 0.01436145 2.349865e-01       TRUE
# 2 x_dobra_catN     TRUE 0.26478467 4.332649e-08       TRUE
#   extraModelDegrees  origName code
# 1                24     x_zla catN
# 2                 1   x_dobra catN

# Uwaga 1. 
#   Testy F dla danych i statystyki ramki oceny pokrywaj si teraz w duym stopniu. 

