// obiekt sound
sound = function(){
	this.preloaded = false;
	
	// Pobieranie dźwięku
	this.preload = function(url){
		var request = new XMLHttpRequest();
		request.open('GET', url, true);
		request.responseType = 'arraybuffer';
		
		// Asynchroniczne dekodowanie
		var that = this;
		request.onload = function() {
			sound.context.decodeAudioData(request.response, function(buffer) {
				that.soundBuffer = buffer;
				that.preloaded = true;
			});
		}
		request.send();
	};
	
	// Zwraca true jeśli dźwięk został pobrany
	this.isPreloaded = function(){
		return this.preloaded;
	}
	
	// Rozpoczyna odtwarzanie dźwięku. 
	// Jeśli loop == true dźwięk będzie odtwarzany w pętli  
	this.play = function(loop){
		this.source = sound.context.createBufferSource();
		this.source.buffer = this.soundBuffer;
		this.source.connect(sound.context.destination);
		this.source.loop = true;
		this.source.start(0);
	};
	
	// Zatrzymuje odtwarzanie
	this.stop = function(){
		this.source.stop(0);
	};
};

sound.context = new webkitAudioContext();
