sound = function(){
	
	this.preloadStarted = false;
	
	// Pobieranie dźwięku
	this.preload = function(url){
		if(sound.ready){
			this.audio = soundManager.createSound({
				id: 'sound'+sound.counter++,
				url: url,
				autoLoad: true,
				autoPlay: false,
				volume: 50
			});
			this.preloadStarted = true;
		} else {
			this.url = url;
		}
	};
	
	// Zwraca true jeśli dźwięk został pobrany
	this.isPreloaded = function(){
		if (!this.preloadStarted){
			this.preload(this.url);
			return false;
		} else {
			return (this.audio.readyState == 3)
		}
	}
	
	// Rozpoczyna odtwarzanie dźwięku. 
	// Jeśli loop == true dźwięk będzie odtwarzany w pętli 
	this.play = function(loop){
		this.audio.loops = loop;
		this.audio.play();
	};
	
	// Wstrzymuje odtwarzanie
	this.pause = function(loop){
		this.audio.pause();
	};
	
	// Zatrzymuje odtwarzanie
	this.stop = function(){
		this.audio.stop();
	};
};

sound.ready = false;
sound.counter = 0;
// obiekt sound
soundManager.setup({
  url: 'sm2.swf',
  flashVersion: 8, 
  useFlashBlock: false, // opcjonalnie można ustawić, ale trzeba będzie obsłużyć
  useHTML5Audio: true,
  onready: function() {
    sound.ready = true;
  }
});
