﻿<?php
/**
* @version $Id: guestbook.php 5203 2007-06-15 02:45:14Z DanR $
* @copyright (C) 2007 Dan Rahmel, wszystkie prawa zastrzeżone.
* @package Księga gości
* Komponent ten wyświetla listę wpisów w księdze gości i umożliwia dodawanie 
* nowych komentarzy przez zarejestrowanych użytkowników
*/

// zablokuj bezpośredni dostęp
defined( '_JEXEC' ) or die ( 'Brak dostępu' );

// Sprawdź wartość parametru task i wywołaj odpowiednią funkcję
switch( JRequest::getVar( 'task' )) {
   case 'add':
      addEntry();
      break;
   default:
      displayGuestbook();
      break;
}

// Przetwórz dane z nadesłanego formularza
function addEntry() {
   // Pobierz referencję obiektu bazy danych
   $db =& JFactory::getDBO();
   // Pobierz id użytkownika dodającego wpis
   $user =& JFactory::getUser();
   $uid = $user->get('id');

   // Pobierz treść wiadomości i lokację z formularza
   $fldMessage = JRequest::getVar('message');
   // Usuń wszystkie znaki, które mogą tworzyć kod HTML, znaki powrotu karetki itp
   $fldMessage = preg_replace("/[^a-zA-ZąćęłóńśźżĄĆĘŁÓŃŚŹŻ0-9 .?!$()\'\"]/", "", $fldMessage);
   // Dodaj znaki unikowe do treści wiadomości i lokacji, aby można było ją umieścić w instrukcji insert
   $fldMessage = "'" . $db->getEscaped($fldMessage) . "'";
   $fldLocation = "'" . $db->getEscaped(JRequest::getVar( 'location' )) . "'";
   // Pobierz adres IP i przechowaj go z powodów bezpieczeństwa
   $userIp = "'" . $_SERVER['REMOTE_ADDR'] . "'";

   $insertFields = "INSERT INTO #__guestbook " .
      "(message, created_by, location, userip) " .
      "VALUES (" . $fldMessage . ", " . intval($uid) . "," .
         $fldLocation . "," . $userIp . ");";
   $db->setQuery( $insertFields, 0);
   $db->query();
   echo "<h1>Dziękujemy za dodanie wpisu!</h1>";
   echo "<a href=index.php?option=com_guestbook>" .
      "Powrót do księgi gości </a>";
}

// Wyświetl listę wpisów w księdze gości
function displayGuestbook() {
   $db =& JFactory::getDBO();
   // Wykonaj zapytanie do bazy danych i pobierz listę wpisów
   $query = "SELECT a.message, u.name" .
   " FROM #__guestbook AS a" .
   " LEFT JOIN #__users AS u ON u.id=a.created_by" .
   " ORDER BY a.created DESC";

   $db->setQuery( $query, 0);
   // Upewnij się przed wyświetlaniem, że lista wpisów nie jest pusta
   if($rows = $db->loadObjectList()) {
      foreach ($rows as $row)
      {
         // Sformatuj tekst do wyświetlania na stronie HTML
         $rowMessage = htmlspecialchars($row->message, ENT_QUOTES);
         echo "<b>" . $rowMessage . "</b>";
         echo " - " . $row->name;
         // Oddziel wpisy poziomymi liniami
         echo "<hr />";
      }
   }

// Wyświetl formularz dla nowych wpisów
?>
<h1 class="contentheading">Formularz dodawania wpisu do księgi gości</h1>

<form id="form1" name="form1" method="post"
  action="index.php?option=com_guestbook&task=add">
   <p>Wprowadź treść wiadomości:<br />
      <textarea name="message" cols="60" rows="4" id="message"></textarea>
   </p>
   <p>
      <label>Lokacja (opcjonalne) : </label>
      <input name="location" type="text" id="location" />
   </p>
   <p>
      <input type="submit" name="Submit" value="Dodaj wpis" />
   </p>
</form>

<?php } ?>