<?php
/**
* @version $Id: scrape.php 5203 2007-06-15 02:45:14Z DanR $
* @copyright Copyright (C) 2007 Dan Rahmel. Wszystkie prawa zastrzeżone.
* @package ScreenScrape
* Pobiera wartość pola formularza, wyszukuje na stronie zewnętrznej odpowiednie informacje 
* i zwraca sformatowany wynik
*/

// zablokuj bezpośredni dostęp
defined( '_JEXEC' ) or die( 'Brak dostępu' );

// Sprawdź wartość parametru task i uruchom właściwą funkcję
switch( JRequest::getVar( 'task' )) { 
   case 'query': 
      doExecuteQuery(); 
      break; 
   default: 
      displayQueryEntry(); 
      break; 
} 

// Przetwórz dane przesłane w formularzu
function doExecuteQuery()  {      
   // Pobierz wartość pola query
   $fldQuery = JRequest::getVar('query') ;
   // Usuń wszystko co mogłoby być kodem HTML itp.
   $fldQuery = preg_replace("/[^ąćęłńóśźża-zĄĆĘŁŃÓŚŹŻA-Z0-9 .?!$()\'\"]/", "", $fldQuery);
   // "
   $myData = doScrape($fldQuery);
   echo "<h1>Oto wyniki Twojego zapytania</h1>";
   echo "<p>Zapytanie: " . $fldQuery . "<p>";
   echo "<hr />";
   echo $myData;
   echo "<a href=index.php?option=com_scrape>" . 
      "Wróć do Scrape</a>";
}

function doScrape($queryStr) {
   $myUrl = "www.chipublib.org";
   $myPath = "/search/results/terms/" . $queryStr . "/";      
   
   $myGet = "";
   $myAgent = "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1;" .
      " en-US; rv:1.8.1) Gecko/20061010 Firefox/2.0\r\n";
   $myApp = "Content-Type: application/x-www-form-urlencoded";

   $fp = fsockopen($myUrl, 80, $errNum, $errstr, 30);
   if (!$fp) {
      return "Błąd #". $errNum . "przy pobieraniu strony.<br />\n";
   } else {
      $out = "GET " . $myPath . " HTTP/1.0\r\n";
      $out .= "Host: ". $myUrl . "\r\n";
      $out .= $myAgent . $myApp . "\r\n";
      $out .= "Connection: Close\r\n\r\n";
     
      fwrite($fp, $out);
      while (!feof($fp)) { $myGet .= fgets($fp, 128); }
      fclose($fp);

      $pattern = "/<ol class=\"result\">(.*)<\/ol>/s";
      preg_match($pattern, $myGet, $matches);
      return $matches[0];
   }
}

// Wyświetl formularz
function displayQueryEntry() {     
?>
<h1 class="contentheading">Formularz zapytania</h1>

<form id="form1" name="form1" method="post"
    action="index.php?option=com_scrape&task=query">
   <p>Wprowadź poszukiwane słowa kluczow:<br /> 
      <textarea name="query" cols="60" rows="1" id="query"></textarea>
   </p>
   <p>
      <input type="submit" name="Submit" value="Wyświetl wyniki" />
   </p>
</form>

<?php } ?>