﻿<?php
/**
* @version $Id: mod_articleajax.php 5203 2007-07-27 01:45:14Z DanR $
* Ten moduł wyświetla odnośniki do 5 aktualnych artykułów
* Odnośnik do każdego posiada zdefiniowane zdarzenie onMouseOver, które uruchamia
* procedurę ajaksową pobierającą informacje o artykule za pomcą komponentu com_articleinfo.
*/
?>
<script type="text/javascript" src="includes/js/overlib_mini.js"></script>
<script type="text/javascript">
   // Utwórz zmienną dla obiektu XMLHttpRequest
   var myRequest = false;

function displayAjax(tempArticleID) {
   // Wprowadź adres, na który zostanie wysłane żądanie
   var myURL = 
     'http://localhost/index.php?option=com_articleinfo&format=raw&articlenum=' 
     + tempArticleID;
   // Usuń ewentualny poprzedni obiekt
   myRequest = false;

   // Dla przeglądarek takich jak Firefox, Safari i innych które wykorzystują poniższe:
   if (window.XMLHttpRequest) {
      myRequest = new XMLHttpRequest();
      if (myRequest.overrideMimeType) {
         myRequest.overrideMimeType('text/xml');
      }
   } else if (window.ActiveXObject) {
      // Przeglądarka IE6 i wcześniejsze wykorzystują inny model
      try {
         myRequest = new ActiveXObject("Msxml2.XMLHTTP");
      } catch (e) {
         try {
            myRequest = new ActiveXObject("Microsoft.XMLHTTP");
          } catch (e) {}
      }
   }

   // Sprawdź, czy poprawnie otworzono objekt
   if (!myRequest) {
      overlib('Błąd: Nie udało się utworzyć obiektu XMLHttpRequest');
      return false;
   }
     
   // Sprawdź, czy poprawnie otworzono objekt
   myRequest.onreadystatechange = displayReturn;
   // Otwórz docelowy adres URL
   myRequest.open('GET', myURL, true);
   // Wyślij żądanie
   myRequest.send(null);
}
function displayReturn() {
   // Sprawdź, czy żądanie zostało ukończone, 4=ukończone
   if (myRequest.readyState == 4) {
      // Sprawdź kod statusu HTTP
      if (myRequest.status == 200) {
         // Pobierz główny element XML
         var article = myRequest.responseXML.getElementsByTagName('article');
         // Pobierz elementy title i body
	      
         // IE6 wymaga typu mime ustawionego na "text/xml", w przciwnym razie nie odczyta 
	        // Dlatego, jeśli niedostępny jest element o indeksie [0], mamy do czynienia z IE6 i musimy
	        // załadować model obiektu ręcznie.
         if (!article[0]) {
		      myRequest.responseXML.loadXML(myRequest.responseText);
		      var article = myRequest.responseXML.getElementsByTagName('article');
         }
		   myTitle = article[0].getElementsByTagName('title')[0].firstChild.nodeValue;
		   myBody =  article[0].getElementsByTagName('body')[0].firstChild.nodeValue;
	      
         // Wyświetl w postaci "chmurki"
         overlib(myBody,CAPTION,myTitle,BELOW,RIGHT);
      } else {
         // Wystąpił błąd, wyświetl "chmurkę" z komunikatem
         overlib('Wystąpił problem podczas wykonywania żądania.',CAPTION,'Błąd pobierania',BELOW,RIGHT);
      }
   }     
}
</script>

<small>Moduł ajaksowy</small><br />

<?php
   // zablokuj bezpośrednie uruchamianie
   defined( '_JEXEC' ) or die( 'Brak dostepu' );


   // Zdefiniuj lokalne zmienne
   $db =& JFactory::getDBO();
   $user =& JFactory::getUser();
   $userId = (int) $user->get('id');

   // Zdefiniuj odpowiednie daty, aby zagwarantować, że artykuły są dostępne
   $nullDate     = $db->getNullDate();
   $now          = date('Y-m-d H:i:s', time());

   // Wyszukuj wyłącznie opublikowane artykuły
   $where = 'a.state = 1' .
     " AND (a.publish_up = '" . $nullDate . 
     "' OR a.publish_up <= '" . $now . "')" .
     " AND ( a.publish_down = '" . $nullDate .
     "' OR a.publish_down >= '" . $now . "')";
     
   // Utwórz zapytanie
   $query = "SELECT a.id, a.title  \n" .
     " FROM #__content AS a \n" .
     " WHERE " . $where . "\n" .
     " AND a.access <= " . $userId;

   // Uruchom zapytanie i pobierz 5 pierwszych rekordów
   $db->setQuery( $query, 0,5);
   if ($rows = $db->loadObjectList()) {
      // Wykonaj dla każdego rekordu
      foreach ( $rows as $row )
      {
         // Wyświetl tytuł artykułu
         $artTitle = JText::_($row->title);
         // Dodaj zdarzenie onmouseover, które uruchomi funkcję displayAjax()
         echo "<span onmouseover=displayAjax(" . $row->id . "); onmouseout=nd(); >";
         // Utwórz odnośnik do właściwego artykułu
         echo "<a href=index.php?option=com_content&view=article&id=" .
           $row->id . "&Itemid=44>" . $artTitle . "</a><br /></span>\n";
      }
   }
   // Wyświetl komunikat o błędzie jeśli pobieranie danych nie powiodło się
   echo $db->getErrorMsg();
?>